/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.atmosphere.cache.BroadcasterCacheInspector;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcastFilterLifecycle;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterCacheListener;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.atmosphere.cpr.PerRequestBroadcastFilter;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcasterConfig {
    private static final Logger logger = LoggerFactory.getLogger(BroadcasterConfig.class);
    protected final ConcurrentLinkedQueue<BroadcastFilter> filters = new ConcurrentLinkedQueue();
    protected final ConcurrentLinkedQueue<PerRequestBroadcastFilter> perRequestFilters = new ConcurrentLinkedQueue();
    private ExecutorService executorService;
    private ExecutorService asyncWriteService;
    private ScheduledExecutorService scheduler;
    private BroadcasterCache broadcasterCache = BroadcasterCache.DEFAULT;
    private final AtmosphereConfig config;
    private boolean isExecutorShared;
    private boolean isAsyncExecutorShared;
    private final boolean shared;
    private String broadcasterId;
    private boolean handleExecutors;
    private List<String> filterList;

    public BroadcasterConfig(List<String> broadcastFilters, AtmosphereConfig config, String broadcasterId) {
        this(broadcastFilters, config, true, broadcasterId);
    }

    public BroadcasterConfig(List<String> broadcastFilters, AtmosphereConfig config, boolean handleExecutors, String broadcasterId) {
        this.config = config;
        this.broadcasterId = broadcasterId;
        this.shared = config.framework().isShareExecutorServices();
        this.handleExecutors = handleExecutors;
        this.filterList = broadcastFilters;
    }

    public BroadcasterConfig(ExecutorService executorService, ExecutorService asyncWriteService, ScheduledExecutorService scheduler, AtmosphereConfig config, String broadcasterId) {
        this.executorService = executorService;
        this.scheduler = scheduler;
        this.asyncWriteService = asyncWriteService;
        this.config = config;
        this.broadcasterId = broadcasterId;
        this.handleExecutors = true;
        this.shared = config.framework().isShareExecutorServices();
    }

    public BroadcasterConfig init() {
        if (this.handleExecutors) {
            this.configExecutors();
        }
        if (this.filterList != null) {
            this.configureBroadcasterFilter(this.filterList);
        }
        this.configureBroadcasterCache();
        return this;
    }

    private void configureBroadcasterCache() {
        try {
            String className = this.config.framework().getBroadcasterCacheClassName();
            if (className != null) {
                this.broadcasterCache = this.config.framework().newClassInstance(BroadcasterCache.class, IOUtils.loadClass(this.getClass(), className));
                this.configureSharedCacheExecutor();
                this.broadcasterCache.configure(this.config);
            }
            for (BroadcasterCacheInspector b : this.config.framework().inspectors()) {
                this.broadcasterCache.inspector(b);
            }
            for (BroadcasterCacheListener l : this.config.framework().broadcasterCacheListeners()) {
                this.broadcasterCache.addBroadcasterCacheListener(l);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void configureSharedCacheExecutor() {
        if (!this.shared) {
            return;
        }
        this.config.properties().put("shared", "true");
    }

    protected BroadcasterConfig broadcasterID(String broadcasterId) {
        this.broadcasterId = broadcasterId;
        this.initClusterExtension();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClusterExtension() {
        for (BroadcastFilter mf : this.filters) {
            if (!ClusterBroadcastFilter.class.isAssignableFrom(mf.getClass())) continue;
            try {
                Object b = this.config.getBroadcasterFactory().lookup(this.broadcasterId, false);
                if (b == null) continue;
                BroadcastFilter broadcastFilter = mf;
                synchronized (broadcastFilter) {
                    ((ClusterBroadcastFilter)ClusterBroadcastFilter.class.cast(mf)).setBroadcaster((Broadcaster)b);
                }
            }
            catch (Throwable t) {
                logger.error("", t);
            }
        }
    }

    public boolean handleExecutors() {
        return this.handleExecutors;
    }

    protected synchronized void configExecutors() {
        if (this.shared) {
            this.handleExecutors = false;
            this.isExecutorShared = true;
            this.isAsyncExecutorShared = true;
        }
        this.executorService = ExecutorsFactory.getMessageDispatcher(this.config, this.broadcasterId);
        this.asyncWriteService = ExecutorsFactory.getAsyncOperationExecutor(this.config, this.broadcasterId);
        this.scheduler = ExecutorsFactory.getScheduler(this.config);
    }

    public BroadcasterConfig setExecutorService(ExecutorService executorService) {
        return this.setExecutorService(executorService, false);
    }

    public BroadcasterConfig setExecutorService(ExecutorService executorService, boolean isExecutorShared) {
        if (!this.isExecutorShared && this.executorService != null) {
            this.executorService.shutdown();
        }
        this.executorService = executorService;
        this.isExecutorShared = isExecutorShared;
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public BroadcasterConfig setAsyncWriteService(ExecutorService asyncWriteService) {
        return this.setAsyncWriteService(asyncWriteService, false);
    }

    public BroadcasterConfig setAsyncWriteService(ExecutorService asyncWriteService, boolean isAsyncExecutorShared) {
        if (!this.isAsyncExecutorShared && this.asyncWriteService != null) {
            this.asyncWriteService.shutdown();
        }
        this.asyncWriteService = asyncWriteService;
        this.isAsyncExecutorShared = isAsyncExecutorShared;
        return this;
    }

    public ExecutorService getAsyncWriteService() {
        return this.asyncWriteService;
    }

    public boolean addFilter(BroadcastFilter e) {
        return this.addFilter(e, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addFilter(BroadcastFilter e, boolean init) {
        Object b;
        this.logDuplicateFilter(e);
        if (this.filters.contains(e)) {
            return false;
        }
        if (e instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)e).init(this.config);
        }
        if (init && ClusterBroadcastFilter.class.isAssignableFrom(e.getClass()) && (b = this.config.getBroadcasterFactory().lookup(this.broadcasterId, false)) != null) {
            BroadcastFilter broadcastFilter = e;
            synchronized (broadcastFilter) {
                ((ClusterBroadcastFilter)ClusterBroadcastFilter.class.cast(e)).setBroadcaster((Broadcaster)b);
            }
        }
        if (e instanceof PerRequestBroadcastFilter) {
            this.perRequestFilters.add((PerRequestBroadcastFilter)e);
        }
        return this.filters.offer(e);
    }

    private void logDuplicateFilter(BroadcastFilter e) {
        for (BroadcastFilter f : this.filters) {
            if (!f.getClass().isAssignableFrom(e.getClass())) continue;
            logger.trace("Duplicate Filter instance {}", (Object)f.getClass());
        }
    }

    public Collection<BroadcastFilter> filters() {
        return this.filters;
    }

    public void destroy() {
        this.destroy(false);
    }

    protected void destroy(boolean force) {
        this.broadcasterCache.cleanup();
        if ((force || !this.shared) && this.broadcasterCache != null) {
            this.broadcasterCache.stop();
        }
        this.removeAllFilters();
        if (!force && !this.handleExecutors) {
            return;
        }
        if ((force || !this.isExecutorShared) && this.executorService != null) {
            this.executorService.shutdownNow();
        }
        if ((force || !this.isAsyncExecutorShared) && this.asyncWriteService != null) {
            this.asyncWriteService.shutdownNow();
        }
        if ((force || !this.shared) && this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    public void forceDestroy() {
        this.destroy(true);
    }

    public boolean removeFilter(BroadcastFilter filter) {
        if (filter instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)filter).destroy();
        }
        if (filter instanceof PerRequestBroadcastFilter) {
            this.perRequestFilters.remove(filter);
        }
        return this.filters.remove(filter);
    }

    public void removeAllFilters() {
        for (BroadcastFilter filter : this.filters) {
            this.removeFilter(filter);
        }
    }

    public boolean hasFilters() {
        return !this.filters.isEmpty();
    }

    public boolean hasPerRequestFilters() {
        if (this.filters.isEmpty()) {
            return false;
        }
        for (BroadcastFilter b : this.filters) {
            if (!PerRequestBroadcastFilter.class.isAssignableFrom(b.getClass())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BroadcastFilter.BroadcastAction filter(Object object) {
        Object newO = this.unwrap(object);
        boolean isManipulated = false;
        if (newO != null && !newO.equals(object)) {
            isManipulated = true;
            object = newO;
        }
        BroadcastFilter.BroadcastAction transformed = new BroadcastFilter.BroadcastAction(object);
        Iterator<BroadcastFilter> iterator = this.filters.iterator();
        while (iterator.hasNext()) {
            BroadcastFilter mf;
            BroadcastFilter broadcastFilter = mf = iterator.next();
            synchronized (broadcastFilter) {
                transformed = mf.filter(this.broadcasterId, object, transformed.message());
                if (transformed == null || transformed.action() == BroadcastFilter.BroadcastAction.ACTION.ABORT || transformed.action() == BroadcastFilter.BroadcastAction.ACTION.SKIP) {
                    return transformed;
                }
            }
        }
        return this.wrap(transformed, isManipulated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BroadcastFilter.BroadcastAction filter(AtmosphereResource r, Object message, Object originalMessage) {
        Object newO = this.unwrap(message);
        boolean isManipulated = false;
        if (!newO.equals(message)) {
            isManipulated = true;
            message = newO;
        }
        BroadcastFilter.BroadcastAction transformed = new BroadcastFilter.BroadcastAction(message);
        Iterator<PerRequestBroadcastFilter> iterator = this.perRequestFilters.iterator();
        while (iterator.hasNext()) {
            PerRequestBroadcastFilter mf;
            PerRequestBroadcastFilter perRequestBroadcastFilter = mf = iterator.next();
            synchronized (perRequestBroadcastFilter) {
                transformed = mf.filter(this.broadcasterId, r, originalMessage, transformed.message());
                if (transformed == null || transformed.action() == BroadcastFilter.BroadcastAction.ACTION.ABORT || transformed.action() == BroadcastFilter.BroadcastAction.ACTION.SKIP) {
                    return transformed;
                }
            }
        }
        return this.wrap(transformed, isManipulated);
    }

    public List<Object> applyFilters(AtmosphereResource r, List<Object> cacheMessages) {
        LinkedList<Object> filteredMessage = new LinkedList<Object>();
        for (Object o : cacheMessages) {
            BroadcastFilter.BroadcastAction a = this.filter(o);
            if (a.action() == BroadcastFilter.BroadcastAction.ACTION.ABORT) {
                return Collections.emptyList();
            }
            if (a.action() == BroadcastFilter.BroadcastAction.ACTION.SKIP) {
                filteredMessage.add(a.message());
                return filteredMessage;
            }
            if ((a = this.filter(r, a.message(), a.originalMessage())).action() == BroadcastFilter.BroadcastAction.ACTION.ABORT) {
                return Collections.emptyList();
            }
            if (a.action() == BroadcastFilter.BroadcastAction.ACTION.SKIP) {
                filteredMessage.add(a.message());
                return filteredMessage;
            }
            filteredMessage.add(a.message());
        }
        return filteredMessage;
    }

    public BroadcasterConfig setScheduledExecutorService(ScheduledExecutorService scheduler) {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        this.scheduler = scheduler;
        return this;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduler;
    }

    public BroadcasterConfig setBroadcasterCache(BroadcasterCache broadcasterCache) {
        this.broadcasterCache = broadcasterCache;
        return this;
    }

    public BroadcasterCache getBroadcasterCache() {
        return this.broadcasterCache;
    }

    void configureBroadcasterFilter(List<String> list) {
        for (String broadcastFilter : list) {
            BroadcastFilter bf = null;
            try {
                bf = this.config.framework().newClassInstance(BroadcastFilter.class, IOUtils.loadClass(this.getClass(), broadcastFilter));
            }
            catch (Exception e) {
                logger.warn("Error trying to instantiate BroadcastFilter: {}", (Object)broadcastFilter, (Object)e);
            }
            if (bf == null) continue;
            this.addFilter(bf);
        }
    }

    protected Object unwrap(Object o) {
        Object manipulated = o;
        for (FilterManipulator f : this.config.framework().filterManipulators()) {
            manipulated = f.unwrap(manipulated);
        }
        return manipulated;
    }

    protected BroadcastFilter.BroadcastAction wrap(BroadcastFilter.BroadcastAction a, boolean wasUnwraped) {
        for (FilterManipulator f : this.config.framework().filterManipulators()) {
            a = f.wrap(a, wasUnwraped);
        }
        return a;
    }

    public AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    public static interface FilterManipulator {
        public Object unwrap(Object var1);

        public BroadcastFilter.BroadcastAction wrap(BroadcastFilter.BroadcastAction var1, boolean var2);
    }
}

