/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import javax.servlet.annotation.HandlesTypes;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.service.AsyncSupportListenerService;
import org.atmosphere.config.service.AsyncSupportService;
import org.atmosphere.config.service.AtmosphereFrameworkListenerService;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.config.service.AtmosphereInterceptorService;
import org.atmosphere.config.service.AtmosphereResourceFactoryService;
import org.atmosphere.config.service.AtmosphereResourceListenerService;
import org.atmosphere.config.service.AtmosphereService;
import org.atmosphere.config.service.BroadcasterCacheInspectorService;
import org.atmosphere.config.service.BroadcasterCacheListenerService;
import org.atmosphere.config.service.BroadcasterCacheService;
import org.atmosphere.config.service.BroadcasterFactoryService;
import org.atmosphere.config.service.BroadcasterFilterService;
import org.atmosphere.config.service.BroadcasterListenerService;
import org.atmosphere.config.service.BroadcasterService;
import org.atmosphere.config.service.EndpointMapperService;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.MeteorService;
import org.atmosphere.config.service.UUIDProviderService;
import org.atmosphere.config.service.WebSocketFactoryService;
import org.atmosphere.config.service.WebSocketHandlerService;
import org.atmosphere.config.service.WebSocketProcessorService;
import org.atmosphere.config.service.WebSocketProtocolService;
import org.atmosphere.cpr.AnnotationHandler;
import org.atmosphere.cpr.AnnotationProcessor;
import org.atmosphere.cpr.AnnotationScanningServletContainerInitializer;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.util.IOUtils;
import org.atmosphere.util.annotation.AnnotationDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnnotationProcessor
implements AnnotationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAnnotationProcessor.class);
    public static final String ANNOTATION_ATTRIBUTE = "org.atmosphere.cpr.ANNOTATION_MAP";
    private static final Class[] coreAnnotations = new Class[]{AtmosphereHandlerService.class, BroadcasterCacheService.class, BroadcasterFilterService.class, BroadcasterFactoryService.class, BroadcasterService.class, MeteorService.class, WebSocketFactoryService.class, WebSocketHandlerService.class, WebSocketProtocolService.class, AtmosphereInterceptorService.class, BroadcasterListenerService.class, AsyncSupportService.class, AsyncSupportListenerService.class, WebSocketProcessorService.class, BroadcasterCacheInspectorService.class, ManagedService.class, AtmosphereService.class, EndpointMapperService.class, BroadcasterCacheListenerService.class, AtmosphereAnnotation.class, AtmosphereResourceFactoryService.class, AtmosphereFrameworkListenerService.class, AtmosphereResourceListenerService.class, UUIDProviderService.class};
    private AnnotationProcessor delegate;
    private final AnnotationHandler handler;
    private final AtomicBoolean coreAnnotationsFound = new AtomicBoolean();
    private final AnnotationDetector.TypeReporter atmosphereReporter = new AnnotationDetector.TypeReporter(){

        @Override
        public Class<? extends Annotation>[] annotations() {
            return new Class[]{AtmosphereAnnotation.class};
        }

        @Override
        public void reportTypeAnnotation(Class<? extends Annotation> annotation, String className) {
            try {
                DefaultAnnotationProcessor.this.coreAnnotationsFound.set(true);
                DefaultAnnotationProcessor.this.handler.handleProcessor(IOUtils.loadClass(this.getClass(), className));
            }
            catch (Exception e) {
                logger.warn("Error scanning @AtmosphereAnnotation", e);
            }
        }
    };

    public DefaultAnnotationProcessor() {
        this.handler = new AnnotationHandler();
    }

    @Override
    public void configure(AtmosphereConfig config) {
        ServletContext sc = config.framework().getServletContext();
        Map annotations = (Map)sc.getAttribute(ANNOTATION_ATTRIBUTE);
        sc.removeAttribute(ANNOTATION_ATTRIBUTE);
        boolean useByteCodeProcessor = config.getInitParameter("org.atmosphere.cpr.annotation.useBytecodeProcessor", false);
        boolean scanForAtmosphereAnnotation = false;
        if (useByteCodeProcessor || annotations == null || annotations.isEmpty()) {
            this.delegate = new BytecodeBasedAnnotationProcessor(this.handler);
            scanForAtmosphereAnnotation = true;
        } else {
            HashMap clone = new HashMap();
            clone.putAll(annotations);
            this.delegate = new ServletContainerInitializerAnnotationProcessor(this.handler, clone, config.framework());
        }
        logger.info("AnnotationProcessor {} being used", (Object)this.delegate.getClass());
        if (scanForAtmosphereAnnotation) {
            this.scanForAnnotation(config.framework());
        }
        this.delegate.configure(config.framework().getAtmosphereConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanForAnnotation(AtmosphereFramework f) {
        List<String> packages = f.customAnnotationPackages();
        AnnotationDetector detector = new AnnotationDetector(this.atmosphereReporter);
        try {
            File libFolder;
            File[] jars;
            String pathLibs;
            String path;
            if (!packages.isEmpty()) {
                for (String p : packages) {
                    logger.trace("Package {} scanned for @AtmosphereAnnotation", (Object)p);
                    detector.detect(p);
                }
            }
            if ((path = IOUtils.realPath(f.getServletContext(), f.getHandlersPath())) != null) {
                detector.detect(new File(path));
            }
            if ((pathLibs = IOUtils.realPath(f.getServletContext(), f.getLibPath())) != null && (jars = (libFolder = new File(pathLibs)).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File arg0, String arg1) {
                    return arg1.endsWith(".jar");
                }
            })) != null) {
                for (File file : jars) {
                    detector.detect(file);
                }
            }
            if (!this.coreAnnotationsFound.get()) {
                DefaultAnnotationProcessor.fallbackToManualAnnotatedClasses(this.getClass(), f, this.handler);
            }
        }
        catch (IOException e) {
            logger.warn("Unable to scan annotation", e);
        }
        finally {
            detector.destroy();
        }
    }

    private static void fallbackToManualAnnotatedClasses(Class<?> mainClass, AtmosphereFramework f, AnnotationHandler handler) {
        logger.warn("Unable to detect annotations. Application may fail to deploy.");
        f.annotationScanned(true);
        for (Class a : coreAnnotations) {
            try {
                handler.handleProcessor(IOUtils.loadClass(mainClass, a.getName()));
            }
            catch (Exception e) {
                logger.trace("", e);
            }
        }
    }

    @Override
    public AnnotationProcessor scan(File rootDir) throws IOException {
        this.delegate.scan(rootDir);
        return this;
    }

    @Override
    public AnnotationProcessor scan(String packageName) throws IOException {
        this.delegate.scan(packageName);
        return this;
    }

    @Override
    public AnnotationProcessor scanAll() throws IOException {
        this.delegate.scanAll();
        return this;
    }

    @Override
    public void destroy() {
        if (this.delegate != null) {
            this.delegate.destroy();
            this.handler.destroy();
            this.delegate = null;
        }
    }

    private static final class BytecodeBasedAnnotationProcessor
    implements AnnotationProcessor {
        protected AnnotationDetector detector;
        protected final AnnotationHandler handler;

        public BytecodeBasedAnnotationProcessor(AnnotationHandler handler) {
            this.handler = handler;
        }

        @Override
        public void configure(final AtmosphereConfig config) {
            AnnotationDetector.TypeReporter reporter = new AnnotationDetector.TypeReporter(){

                @Override
                public Class<? extends Annotation>[] annotations() {
                    return BytecodeBasedAnnotationProcessor.this.handler.handledClass();
                }

                @Override
                public void reportTypeAnnotation(Class<? extends Annotation> annotation, String className) {
                    try {
                        Class<?> discoveredClass = IOUtils.loadClass(this.getClass(), className);
                        BytecodeBasedAnnotationProcessor.this.handler.handleAnnotation(config.framework(), annotation, discoveredClass);
                    }
                    catch (Exception e) {
                        logger.warn("Could not load discovered class", e);
                    }
                }
            };
            this.detector = new AnnotationDetector(reporter);
        }

        @Override
        public AnnotationProcessor scan(File rootDir) throws IOException {
            this.detector.detect(rootDir);
            return this;
        }

        @Override
        public AnnotationProcessor scan(String packageName) throws IOException {
            logger.trace("Scanning @Service annotations in {}", (Object)packageName);
            this.detector.detect(packageName);
            return this;
        }

        @Override
        public AnnotationProcessor scanAll() throws IOException {
            this.detector.detect();
            return this;
        }

        @Override
        public void destroy() {
            if (this.detector != null) {
                this.detector.destroy();
            }
        }
    }

    private static final class ServletContainerInitializerAnnotationProcessor
    implements AnnotationProcessor {
        private final Map<Class<? extends Annotation>, Set<Class<?>>> annotations;
        private final AtmosphereFramework framework;
        private final AnnotationHandler handler;
        private boolean alreadyScanned;

        private ServletContainerInitializerAnnotationProcessor(AnnotationHandler handler, Map<Class<? extends Annotation>, Set<Class<?>>> annotations, AtmosphereFramework framework) {
            this.annotations = annotations;
            this.framework = framework;
            this.handler = handler;
        }

        @Override
        public void configure(AtmosphereConfig config) {
        }

        @Override
        public AnnotationProcessor scan(File rootDir) throws IOException {
            if (this.alreadyScanned) {
                return this;
            }
            this.alreadyScanned = true;
            Set<Class<?>> atmosphereAnnotatedClasses = this.annotations.get(AtmosphereAnnotation.class);
            boolean handleAtmosphereAnnotation = this.handleAtmosphereAnnotation(atmosphereAnnotatedClasses);
            for (Map.Entry<Class<Annotation>, Set<Class<?>>> entry : this.annotations.entrySet()) {
                for (Class<?> clazz : entry.getValue()) {
                    this.handler.handleAnnotation(this.framework, entry.getKey(), clazz);
                }
            }
            if (handleAtmosphereAnnotation) {
                this.scanForCustomAnnotation(atmosphereAnnotatedClasses);
            }
            return this;
        }

        private boolean handleAtmosphereAnnotation(Set<Class<?>> atmosphereAnnotatedClasses) {
            boolean scanForCustomizedAnnotation = false;
            if (atmosphereAnnotatedClasses != null) {
                for (Class<?> clazz : atmosphereAnnotatedClasses) {
                    this.handler.handleProcessor(clazz);
                }
            } else {
                DefaultAnnotationProcessor.fallbackToManualAnnotatedClasses(this.getClass(), this.framework, this.handler);
            }
            if (atmosphereAnnotatedClasses != null && atmosphereAnnotatedClasses.size() >= AnnotationScanningServletContainerInitializer.class.getAnnotation(HandlesTypes.class).value().length) {
                scanForCustomizedAnnotation = true;
            }
            return scanForCustomizedAnnotation;
        }

        private void scanForCustomAnnotation(Set<Class<?>> atmosphereAnnotatedClasses) throws IOException {
            this.handler.flushCoreAnnotations(atmosphereAnnotatedClasses);
            BytecodeBasedAnnotationProcessor b = new BytecodeBasedAnnotationProcessor(this.handler);
            b.configure(this.framework.getAtmosphereConfig());
            String path = this.framework.getServletContext().getRealPath(this.framework.getHandlersPath());
            if (path != null) {
                b.scan(new File(path)).destroy();
            } else {
                logger.warn("Unable to scan using File. Scanning classpath");
                b.scanAll();
            }
        }

        @Override
        public AnnotationProcessor scan(String packageName) throws IOException {
            Set<Class<?>> atmosphereAnnotatedClasses = this.annotations.get(AtmosphereAnnotation.class);
            if (packageName.equals("all") || this.getClass().getClassLoader().getResource(packageName.replace(".", "/")) != null) {
                boolean handleAtmosphereAnnotation = this.handleAtmosphereAnnotation(atmosphereAnnotatedClasses);
                for (Map.Entry<Class<Annotation>, Set<Class<?>>> entry : this.annotations.entrySet()) {
                    for (Class<?> clazz : entry.getValue()) {
                        if (!packageName.equals("all") && !clazz.getPackage().getName().startsWith(packageName)) continue;
                        this.handler.handleAnnotation(this.framework, entry.getKey(), clazz);
                    }
                }
                if (handleAtmosphereAnnotation) {
                    this.scanForCustomAnnotation(atmosphereAnnotatedClasses);
                }
            }
            return this;
        }

        @Override
        public AnnotationProcessor scanAll() throws IOException {
            return this.scan("all");
        }

        @Override
        public void destroy() {
            this.annotations.clear();
        }
    }
}

