/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;

public class NettyWebSocketFragmenter {
    private final Channel channel;
    private final int maxFrameSize;

    public NettyWebSocketFragmenter(Channel channel, int maxFrameSize) {
        this.channel = channel;
        this.maxFrameSize = maxFrameSize;
    }

    public void write(byte[] data, int offset, int length, boolean binary) {
        if (length <= this.maxFrameSize) {
            this.channel.writeAndFlush(NettyWebSocketFragmenter.getWebSocketFrameFinal(Unpooled.wrappedBuffer(data, offset, length), binary));
        } else {
            int i;
            this.channel.write(NettyWebSocketFragmenter.getWebSocketFrameNotFinal(Unpooled.wrappedBuffer(data, offset, this.maxFrameSize), binary));
            int lengthMinusMaxFrameSize = length - this.maxFrameSize;
            for (i = offset + this.maxFrameSize; i < lengthMinusMaxFrameSize; i += this.maxFrameSize) {
                this.channel.write(new ContinuationWebSocketFrame(false, 0, Unpooled.wrappedBuffer(data, i, this.maxFrameSize)));
            }
            this.channel.write(new ContinuationWebSocketFrame(true, 0, Unpooled.wrappedBuffer(data, i, length - i)));
            this.channel.flush();
        }
    }

    private static WebSocketFrame getWebSocketFrameFinal(ByteBuf bb, boolean binary) {
        return binary ? new BinaryWebSocketFrame(bb) : new TextWebSocketFrame(bb);
    }

    private static WebSocketFrame getWebSocketFrameNotFinal(ByteBuf bb, boolean binary) {
        return binary ? new BinaryWebSocketFrame(false, 0, bb) : new TextWebSocketFrame(false, 0, bb);
    }
}

