/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import javax.net.ssl.SSLEngine;
import org.atmosphere.nettosphere.BridgeRuntime;
import org.atmosphere.nettosphere.Config;
import org.atmosphere.nettosphere.util.Utils;

class NettyChannelInitializer
extends ChannelInitializer {
    private final transient BridgeRuntime bridgeRuntime;
    private final transient Config config;

    public NettyChannelInitializer(BridgeRuntime bridgeRuntime) {
        this.bridgeRuntime = bridgeRuntime;
        this.config = bridgeRuntime.config();
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.config.sslContext() != null) {
            SSLEngine e = this.config.sslContext().createSSLEngine();
            this.config.sslContextListener().onPostCreate(e);
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(e));
        }
        if (this.config.nettySslContext() != null) {
            pipeline.addLast("ssl", (ChannelHandler)this.config.nettySslContext().newHandler(ch.alloc()));
        }
        if (Utils.isJersey()) {
            pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        } else {
            pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        }
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.config.maxChunkContentLength()));
        if (this.config.supportChunking()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        for (ChannelInboundHandler h : this.config.channelUpstreamHandlers()) {
            pipeline.addLast(h.getClass().getName(), (ChannelHandler)h);
        }
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
        pipeline.addLast(new ChannelHandler[]{new WebSocketFrameAggregator(this.config.maxWebSocketFrameAggregatorContentLength())});
        pipeline.addLast(BridgeRuntime.class.getName(), (ChannelHandler)this.bridgeRuntime);
    }
}

