/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelId;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.nettosphere.BridgeRuntime;
import org.atmosphere.nettosphere.NettyWebSocketFragmenter;
import org.atmosphere.nettosphere.util.Utils;
import org.atmosphere.util.IOUtils;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocket
extends WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(NettyWebSocket.class);
    private final Channel channel;
    private final AtomicBoolean firstWrite = new AtomicBoolean(false);
    private boolean binaryWrite = false;
    private final boolean noInternalAlloc;
    private Future<?> closeFuture;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private ChannelId id;
    private NettyWebSocketFragmenter fragmenter;

    public NettyWebSocket(Channel channel, AtmosphereConfig config, boolean noInternalAlloc, boolean binaryWrite, int maxFrameSize) {
        super(config);
        this.channel = channel;
        this.fragmenter = new NettyWebSocketFragmenter(channel, maxFrameSize);
        this.noInternalAlloc = noInternalAlloc;
        this.binaryWrite = binaryWrite;
        this.lastWrite = System.currentTimeMillis();
    }

    @Override
    public WebSocket resource(AtmosphereResource r) {
        super.resource(r);
        if (this.noInternalAlloc) {
            String string = this.uuid = BridgeRuntime.NETTY_41_PLUS ? this.channel.id().asLongText() : Utils.id(this.channel);
            if (BridgeRuntime.NETTY_41_PLUS) {
                this.id = this.channel.id();
            }
        }
        if (!this.binaryWrite && r != null && r.getRequest() != null) {
            try {
                this.binaryWrite = IOUtils.isBodyBinary(r.getRequest());
            }
            catch (Exception ex) {
                logger.trace("", (Throwable)ex);
            }
        }
        return this;
    }

    @Override
    public WebSocket write(String data) throws IOException {
        return this.write(data.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public WebSocket write(byte[] data) throws IOException {
        return this.write(data, 0, data.length);
    }

    @Override
    public WebSocket write(byte[] data, int offset, int length) throws IOException {
        this.firstWrite.set(true);
        if (!this.channel.isOpen()) {
            throw Utils.REMOTELY_CLOSED;
        }
        logger.trace("WebSocket.write() as binary {}", (Object)this.binaryWrite);
        this.fragmenter.write(data, offset, length, this.binaryWrite);
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() {
        this._close(new CloseWebSocketFrame());
    }

    @Override
    public void close(int statusCode, String reasonText) {
        this._close(new CloseWebSocketFrame(statusCode, reasonText));
    }

    private void _close(CloseWebSocketFrame closeFrame) {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        this.channel.writeAndFlush((Object)closeFrame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        if (this.closeFuture != null) {
            this.closeFuture.cancel(true);
        }
    }

    @Override
    public WebSocket sendPing(byte[] payload) {
        this.channel.writeAndFlush((Object)new PingWebSocketFrame(Unpooled.wrappedBuffer((byte[])payload)));
        return this;
    }

    @Override
    public WebSocket sendPong(byte[] payload) {
        this.channel.writeAndFlush((Object)new PongWebSocketFrame(Unpooled.wrappedBuffer((byte[])payload)));
        return this;
    }

    public String address() {
        return ((InetSocketAddress)this.channel.remoteAddress()).getAddress().getHostAddress();
    }

    protected WebSocket closeFuture(Future<?> closeFuture) {
        this.closeFuture = closeFuture;
        return this;
    }

    protected Future<?> closeFuture() {
        return this.closeFuture;
    }

    public ChannelId id() {
        return this.id;
    }
}

