/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.CompletionAware;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.KeepOpenStreamAware;
import org.atmosphere.util.CookieUtil;
import org.atmosphere.util.ServletProxyFactory;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereResponseImpl
extends HttpServletResponseWrapper
implements AtmosphereResponse,
CompletionAware {
    private static final boolean servlet30;
    private static final Logger logger;
    private static final ThreadLocal<Object> NO_BUFFERING;
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final Map<String, String> headers;
    private AsyncIOWriter asyncIOWriter;
    private int status = 200;
    private String statusMessage = "OK";
    private String charSet = "UTF-8";
    private long contentLength = -1L;
    private String contentType = "text/html";
    private boolean isCommited;
    private Locale locale;
    private boolean headerHandled;
    private AtmosphereRequest atmosphereRequest;
    private static final HttpServletResponse dsr;
    private final AtomicBoolean writeStatusAndHeader = new AtomicBoolean(false);
    private boolean delegateToNativeResponse;
    private boolean destroyable;
    private HttpServletResponse response;
    private boolean forceAsyncIOWriter;
    private String uuid = "0";
    private final AtomicBoolean usingStream = new AtomicBoolean(true);
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final AtomicReference<Object> buffered = new AtomicReference<Object>(null);
    private boolean completed;

    public AtmosphereResponseImpl(AsyncIOWriter asyncIOWriter, AtmosphereRequest atmosphereRequest, boolean destroyable) {
        super(dsr);
        this.response = dsr;
        this.asyncIOWriter = asyncIOWriter;
        this.atmosphereRequest = atmosphereRequest;
        this.writeStatusAndHeader.set(false);
        this.headers = new HashMap<String, String>();
        this.delegateToNativeResponse = asyncIOWriter == null;
        this.destroyable = destroyable;
    }

    public AtmosphereResponseImpl(HttpServletResponse r, AsyncIOWriter asyncIOWriter, AtmosphereRequest atmosphereRequest, boolean destroyable) {
        super(r);
        this.response = r;
        this.asyncIOWriter = asyncIOWriter;
        this.atmosphereRequest = atmosphereRequest;
        this.writeStatusAndHeader.set(false);
        this.headers = new HashMap<String, String>();
        this.delegateToNativeResponse = asyncIOWriter == null;
        this.destroyable = destroyable;
    }

    private AtmosphereResponseImpl(Builder b) {
        super(b.atmosphereResponse);
        this.response = b.atmosphereResponse;
        this.asyncIOWriter = b.asyncIOWriter;
        this.atmosphereRequest = b.atmosphereRequest;
        this.status = b.status;
        this.statusMessage = b.statusMessage;
        this.writeStatusAndHeader.set(b.writeStatusAndHeader.get());
        this.headers = b.headers;
        this.delegateToNativeResponse = this.asyncIOWriter == null;
        this.destroyable = b.destroyable;
    }

    private HttpServletResponse _r() {
        return this.response;
    }

    @Override
    public void destroy() {
        this.destroy(this.destroyable);
    }

    @Override
    public void destroy(boolean force) {
        if (!force) {
            return;
        }
        logger.trace("{} destroyed", (Object)this.uuid);
        this.cookies.clear();
        this.headers.clear();
        this.atmosphereRequest = null;
        this.asyncIOWriter = null;
        this.destroyed.set(true);
    }

    @Override
    public boolean destroyed() {
        return this.destroyed.get();
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (this.delegateToNativeResponse) {
            this._r().addCookie(cookie);
        } else {
            this.cookies.add(cookie);
        }
    }

    @Override
    public boolean containsHeader(String name) {
        return !this.delegateToNativeResponse ? this.headers.get(name) != null : this._r().containsHeader(name);
    }

    @Override
    public String encodeURL(String url) {
        return this.response.encodeURL(url);
    }

    @Override
    public String encodeRedirectURL(String url) {
        return this.response.encodeRedirectURL(url);
    }

    @Override
    public String encodeUrl(String url) {
        return this.response.encodeURL(url);
    }

    @Override
    public String encodeRedirectUrl(String url) {
        return this.response.encodeRedirectURL(url);
    }

    @Override
    public AtmosphereResponse delegateToNativeResponse(boolean delegateToNativeResponse) {
        this.delegateToNativeResponse = delegateToNativeResponse;
        return this;
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        if (this.forceAsyncIOWriter || !this.delegateToNativeResponse) {
            this.setStatus(sc, msg);
            boolean b = this.forceAsyncIOWriter;
            this.forceAsyncIOWriter = false;
            this.asyncIOWriter.writeError(this, sc, msg);
            this.forceAsyncIOWriter = b;
        } else if (!this._r().isCommitted()) {
            this._r().sendError(sc, msg);
        } else {
            logger.warn("Committed error code {} {}", (Object)sc, (Object)msg);
        }
    }

    @Override
    public void sendError(int sc) throws IOException {
        if (this.forceAsyncIOWriter || !this.delegateToNativeResponse) {
            this.setStatus(sc);
            boolean b = this.forceAsyncIOWriter;
            this.forceAsyncIOWriter = false;
            this.asyncIOWriter.writeError(this, sc, "");
            this.forceAsyncIOWriter = b;
        } else if (!this._r().isCommitted()) {
            this._r().sendError(sc);
        } else {
            logger.warn("Committed error code {}", (Object)sc);
        }
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        if (this.forceAsyncIOWriter || !this.delegateToNativeResponse) {
            boolean b = this.forceAsyncIOWriter;
            this.forceAsyncIOWriter = false;
            this.asyncIOWriter.redirect(this, location);
            this.forceAsyncIOWriter = b;
        } else {
            this._r().sendRedirect(location);
        }
    }

    @Override
    public void setDateHeader(String name, long date) {
        if (!this.delegateToNativeResponse) {
            this.headers.put(name, String.valueOf(date));
        } else {
            this._r().setDateHeader(name, date);
        }
    }

    @Override
    public void addDateHeader(String name, long date) {
        if (!this.delegateToNativeResponse) {
            this.headers.put(name, String.valueOf(date));
        } else {
            this._r().setDateHeader(name, date);
        }
    }

    @Override
    public void setHeader(String name, String value) {
        if (value == null) {
            this.headers.remove(name);
        } else {
            this.headers.put(name, value);
        }
        if (this.delegateToNativeResponse) {
            this._r().setHeader(name, value);
        }
        if (name.equalsIgnoreCase("X-Atmosphere-tracking-id")) {
            this.uuid = value;
        }
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
        if (this.delegateToNativeResponse) {
            this._r().addHeader(name, value);
        }
    }

    @Override
    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    @Override
    public void addIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    @Override
    public void setStatus(int status) {
        if (!this.delegateToNativeResponse) {
            this.status = status;
        } else {
            this._r().setStatus(status);
        }
    }

    @Override
    public void setStatus(int status, String statusMessage) {
        if (!this.delegateToNativeResponse) {
            this.statusMessage = statusMessage;
            this.status = status;
        } else {
            this._r().setStatus(status, statusMessage);
        }
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public ServletResponse getResponse() {
        if (Proxy.class.isAssignableFrom(this.response.getClass())) {
            return this;
        }
        return super.getResponse();
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public Map<String, String> headers() {
        if (!this.headerHandled) {
            for (Cookie c : this.cookies) {
                this.headers.put("Set-Cookie", CookieUtil.toString(c));
            }
            this.headerHandled = true;
        }
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        if (name.equalsIgnoreCase("content-type")) {
            String s = this.headers.get("Content-Type");
            if (s == null && servlet30) {
                s = this._r().getHeader(name);
            }
            return s == null ? this.contentType : s;
        }
        String s = this.headers.get(name);
        if (s == null && servlet30) {
            s = this._r().getHeader(name);
        }
        return s;
    }

    @Override
    public Collection<String> getHeaders(String name) {
        Collection<String> r;
        ArrayList<String> s = new ArrayList<String>();
        String h = name.equalsIgnoreCase("content-type") ? this.headers.get("Content-Type") : this.headers.get(name);
        if (this.headers.containsKey(name)) {
            s.add(h);
        }
        if (servlet30 && (r = this._r().getHeaders(name)) != null && !r.isEmpty()) {
            s.addAll(r);
        }
        if (!s.isEmpty()) {
            return Collections.unmodifiableList(s);
        }
        return null;
    }

    @Override
    public Collection<String> getHeaderNames() {
        Collection<String> r = null;
        if (servlet30) {
            r = this._r().getHeaderNames();
        }
        Set<String> s = this.headers.keySet();
        if (r != null && !r.isEmpty()) {
            s = new HashSet<String>(s);
            s.addAll(r);
        }
        return Collections.unmodifiableSet(s);
    }

    @Override
    public void setCharacterEncoding(String charSet) {
        if (!this.delegateToNativeResponse) {
            this.charSet = charSet;
        } else {
            this._r().setCharacterEncoding(charSet);
        }
    }

    @Override
    public void flushBuffer() throws IOException {
        try {
            this.response.flushBuffer();
        }
        catch (NullPointerException ex) {
            this.handleException(ex);
        }
        catch (IOException ex) {
            this.handleException(ex);
            throw ex;
        }
    }

    @Override
    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    @Override
    public String getCharacterEncoding() {
        if (!this.delegateToNativeResponse) {
            return this.charSet;
        }
        return this._r().getCharacterEncoding() == null ? this.charSet : this._r().getCharacterEncoding();
    }

    @Override
    public boolean isDestroyable() {
        return this.destroyable;
    }

    @Override
    public AtmosphereResponse destroyable(boolean destroyable) {
        this.destroyable = destroyable;
        return this;
    }

    private void validAsyncIOWriter() throws IOException {
        if (this.asyncIOWriter == null) {
            logger.trace("{} invalid state", (Object)this.hashCode());
            throw new IOException("AtmosphereResource Cancelled: " + this.uuid);
        }
    }

    private boolean validFlushOrClose() {
        if (this.asyncIOWriter == null) {
            logger.warn("AtmosphereResponse for {} has been closed", (Object)this.uuid);
            return false;
        }
        return true;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.forceAsyncIOWriter || !this.delegateToNativeResponse) {
            return new Stream(this.isBuffering());
        }
        return this._r().getOutputStream() != null ? this._r().getOutputStream() : new ServletOutputStream(){

            @Override
            public void write(int b) {
            }
        };
    }

    private void writeStatusAndHeaders() throws IOException {
        if (this.writeStatusAndHeader.getAndSet(false) && !this.forceAsyncIOWriter) {
            this.asyncIOWriter.write((AtmosphereResponse)this, this.constructStatusAndHeaders());
        }
    }

    private String constructStatusAndHeaders() {
        StringBuilder b = new StringBuilder("HTTP/1.1").append(" ").append(this.status).append(" ").append(this.statusMessage).append("\r\n");
        b.append("Content-Type").append(":").append(this.headers.get("Content-Type") == null ? this.contentType : this.headers.get("Content-Type")).append("\r\n");
        if (this.contentLength != -1L) {
            b.append("Content-Length").append(":").append(this.contentLength).append("\r\n");
        }
        for (String s : this.headers().keySet()) {
            if (s.equalsIgnoreCase("Content-Type")) continue;
            b.append(s).append(":").append(this.headers.get(s)).append("\r\n");
        }
        b.deleteCharAt(b.length() - 2);
        b.append("\r\n\r\n");
        return b.toString();
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.forceAsyncIOWriter || !this.delegateToNativeResponse) {
            return new Writer(new Stream(this.isBuffering()));
        }
        return this._r().getWriter() != null ? this._r().getWriter() : new PrintWriter(new StringWriter());
    }

    @Override
    public void setContentLength(int len) {
        this.headers.put("Content-Length", String.valueOf(len));
        if (!this.delegateToNativeResponse) {
            this.contentLength = len;
        } else {
            this._r().setContentLength(len);
        }
    }

    @Override
    public void setContentType(String contentType) {
        this.headers.put("Content-Type", String.valueOf(contentType));
        if (!this.delegateToNativeResponse) {
            this.contentType = contentType;
        } else {
            this._r().setContentType(contentType);
        }
    }

    @Override
    public String getContentType() {
        return this.getHeader("Content-type");
    }

    @Override
    public boolean isCommitted() {
        if (!this.delegateToNativeResponse) {
            return this.isCommited;
        }
        return this._r().isCommitted();
    }

    @Override
    public void reset() {
        this.response.reset();
    }

    @Override
    public void resetBuffer() {
        this.response.resetBuffer();
    }

    @Override
    public void setBufferSize(int size) {
        this.response.setBufferSize(size);
    }

    @Override
    public void setLocale(Locale locale) {
        if (!this.delegateToNativeResponse) {
            this.locale = locale;
        } else {
            this._r().setLocale(locale);
        }
    }

    @Override
    public Locale getLocale() {
        if (!this.delegateToNativeResponse) {
            return this.locale;
        }
        return this._r().getLocale();
    }

    @Override
    public AsyncIOWriter getAsyncIOWriter() {
        return this.asyncIOWriter;
    }

    @Override
    public AtmosphereResponse asyncIOWriter(AsyncIOWriter asyncIOWriter) {
        this.asyncIOWriter = asyncIOWriter;
        this.forceAsyncIOWriter = true;
        return this;
    }

    @Override
    public AtmosphereRequest request() {
        return this.atmosphereRequest;
    }

    @Override
    public AtmosphereResponse request(AtmosphereRequest atmosphereRequest) {
        this.atmosphereRequest = atmosphereRequest;
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.asyncIOWriter != null) {
            this.asyncIOWriter.close(this);
        }
    }

    @Override
    public void closeStreamOrWriter() {
        if (this.resource() != null) {
            try {
                if (this.isUsingStream()) {
                    this.getOutputStream().close();
                } else {
                    this.getWriter().close();
                }
            }
            catch (Exception e) {
                logger.trace("Unexpected exception", e);
            }
        }
    }

    @Override
    public AtmosphereResponse write(String data) {
        return this.write(data, false);
    }

    private void handleException(Exception ex) {
        AtmosphereResource r = this.resource();
        if (r != null) {
            r.notifyListeners(new AtmosphereResourceEventImpl((AtmosphereResourceImpl)r, true, false));
            r.getAtmosphereConfig().resourcesFactory().remove(this.uuid);
        }
        logger.trace("{} unexpected I/O exception {}", (Object)this.uuid, (Object)ex);
    }

    @Override
    public AtmosphereResponse write(String data, boolean writeUsingOriginalResponse) {
        if (Proxy.class.isAssignableFrom(this.response.getClass())) {
            writeUsingOriginalResponse = false;
        }
        try {
            if (this.isUsingStream()) {
                try {
                    ServletOutputStream o = writeUsingOriginalResponse ? this._r().getOutputStream() : this.getOutputStream();
                    o.write(data.getBytes(this.getCharacterEncoding()));
                }
                catch (IllegalStateException ex) {
                    logger.trace("", ex);
                }
            } else {
                PrintWriter w = writeUsingOriginalResponse ? this._r().getWriter() : this.getWriter();
                w.write(data);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
            throw new RuntimeException(ex);
        }
        return this;
    }

    private boolean isUsingStream() {
        Object s;
        if (this.atmosphereRequest != null && (s = this.atmosphereRequest.getAttribute("org.atmosphere.useStream")) != null) {
            this.usingStream.set((Boolean)s);
        }
        if (this.resource() != null) {
            boolean force = this.resource().forceBinaryWrite();
            if (!this.usingStream.get() && force) {
                this.usingStream.set(true);
            }
        }
        return this.usingStream.get();
    }

    @Override
    public AtmosphereResponse write(byte[] data) {
        return this.write(data, false);
    }

    @Override
    public AtmosphereResponse write(byte[] data, boolean writeUsingOriginalResponse) {
        if (data == null) {
            logger.error("Cannot write null value for {}", (Object)this.resource());
            return this;
        }
        if (Proxy.class.isAssignableFrom(this.response.getClass())) {
            writeUsingOriginalResponse = false;
        }
        try {
            if (this.isUsingStream()) {
                try {
                    ServletOutputStream o = writeUsingOriginalResponse ? this._r().getOutputStream() : this.getOutputStream();
                    o.write(data);
                }
                catch (IllegalStateException ex) {
                    logger.trace("", ex);
                }
            } else {
                PrintWriter w = writeUsingOriginalResponse ? this._r().getWriter() : this.getWriter();
                w.write(new String(data, this.getCharacterEncoding()));
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
            throw new RuntimeException(ex);
        }
        return this;
    }

    @Override
    public AtmosphereResponse write(byte[] data, int offset, int length) {
        return this.write(data, offset, length, false);
    }

    @Override
    public AtmosphereResponse write(byte[] data, int offset, int length, boolean writeUsingOriginalResponse) {
        if (data == null) {
            logger.error("Cannot write null value for {}", (Object)this.resource());
            return this;
        }
        if (Proxy.class.isAssignableFrom(this.response.getClass())) {
            writeUsingOriginalResponse = false;
        }
        try {
            if (this.isUsingStream()) {
                try {
                    ServletOutputStream o = writeUsingOriginalResponse ? this._r().getOutputStream() : this.getOutputStream();
                    o.write(data, offset, length);
                }
                catch (IllegalStateException ex) {
                    logger.trace("", ex);
                }
            } else {
                PrintWriter w = writeUsingOriginalResponse ? this._r().getWriter() : this.getWriter();
                w.write(new String(data, offset, length, this.getCharacterEncoding()));
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
            throw new RuntimeException(ex);
        }
        return this;
    }

    @Override
    public AtmosphereResource resource() {
        if (this.atmosphereRequest != null) {
            return (AtmosphereResource)this.atmosphereRequest.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
        }
        return null;
    }

    @Override
    public void setResponse(ServletResponse response) {
        super.setResponse(response);
        if (HttpServletResponse.class.isAssignableFrom(response.getClass())) {
            this.response = (HttpServletResponse)response;
        }
    }

    public static AtmosphereResponse newInstance() {
        return new Builder().build();
    }

    public static AtmosphereResponse newInstance(AtmosphereRequest request) {
        return new AtmosphereResponseImpl(null, request, request.isDestroyable());
    }

    public static AtmosphereResponse newInstance(AtmosphereConfig config, AtmosphereRequest request, WebSocket webSocket) {
        String s = config.getInitParameter("org.atmosphere.cpr.recycleAtmosphereRequestResponse");
        boolean destroyable = Boolean.parseBoolean(s);
        return new AtmosphereResponseImpl(webSocket, request, destroyable);
    }

    public static AtmosphereResponse wrap(HttpServletResponse response) {
        return new Builder().response(response).build();
    }

    @Override
    public String uuid() {
        return this.uuid;
    }

    @Override
    public String toString() {
        return "AtmosphereResponse{, uuid=" + this.uuid + ", headers=" + this.headers + ", asyncIOWriter=" + this.asyncIOWriter + ", status=" + this.status + ", statusMessage='" + this.statusMessage + '\'' + ", atmosphereRequest=" + this.atmosphereRequest + ", writeStatusAndHeader=" + this.writeStatusAndHeader + ", delegateToNativeResponse=" + this.delegateToNativeResponse + ", destroyable=" + this.destroyable + ", response=" + this.response + '}';
    }

    private boolean isCompletionReset() {
        return this.atmosphereRequest != null && Boolean.TRUE == this.atmosphereRequest.getAttribute("org.atmosphere.cpr.ResponseCompletionReset");
    }

    @Override
    public void onComplete() {
        if (!this.completed) {
            this.completed = true;
            try {
                this.writeWithBuffering(null);
            }
            catch (IOException iOException) {
            }
            finally {
                if (this.isCompletionReset()) {
                    this.completed = false;
                }
            }
        }
    }

    @Override
    public boolean completed() {
        return this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeWithBuffering(Object data) throws IOException {
        if (NO_BUFFERING.get() != null) {
            boolean b = this.forceAsyncIOWriter;
            try {
                if (data instanceof String) {
                    this.asyncIOWriter.write((AtmosphereResponse)this, (String)data);
                    return;
                }
                if (!(data instanceof byte[])) return;
                this.asyncIOWriter.write((AtmosphereResponse)this, (byte[])data);
                return;
            }
            catch (IOException e) {
                this.handleException(e);
                throw e;
            }
            finally {
                this.forceAsyncIOWriter = b;
            }
        }
        try {
            NO_BUFFERING.set(Boolean.TRUE);
            Object previous = this.buffered.getAndSet(data);
            if (previous == null) return;
            boolean b = this.forceAsyncIOWriter;
            try {
                if (previous instanceof String) {
                    this.asyncIOWriter.write((AtmosphereResponse)this, (String)previous);
                    return;
                } else {
                    if (!(previous instanceof byte[])) return;
                    this.asyncIOWriter.write((AtmosphereResponse)this, (byte[])previous);
                    return;
                }
            }
            catch (IOException e) {
                this.handleException(e);
                throw e;
            }
            finally {
                this.forceAsyncIOWriter = b;
            }
        }
        finally {
            NO_BUFFERING.remove();
        }
    }

    private boolean isBuffering() {
        return this.atmosphereRequest != null && Boolean.TRUE == this.atmosphereRequest.getAttribute("org.atmosphere.cpr.ResponseCompletionAware");
    }

    static /* synthetic */ HttpServletResponse access$800() {
        return dsr;
    }

    static {
        Exception exception = null;
        try {
            Class.forName("javax.servlet.AsyncContext");
            servlet30 = exception == null;
        }
        catch (Exception ex) {
            try {
                exception = ex;
                servlet30 = exception == null;
            }
            catch (Throwable throwable) {
                servlet30 = exception == null;
                throw throwable;
            }
        }
        logger = LoggerFactory.getLogger(AtmosphereResponseImpl.class);
        NO_BUFFERING = new ThreadLocal();
        dsr = (HttpServletResponse)Proxy.newProxyInstance(AtmosphereResponseImpl.class.getClassLoader(), new Class[]{HttpServletResponse.class}, (proxy, method, args) -> ServletProxyFactory.getDefault().proxy(proxy, method, args));
    }

    private final class Writer
    extends PrintWriter {
        public Writer(OutputStream out) {
            super(out);
        }

        @Override
        public void write(char[] chars, int offset, int lenght) {
            boolean b = AtmosphereResponseImpl.this.forceAsyncIOWriter;
            try {
                AtmosphereResponseImpl.this.validAsyncIOWriter();
                AtmosphereResponseImpl.this.writeStatusAndHeaders();
                AtmosphereResponseImpl.this.forceAsyncIOWriter = false;
                AtmosphereResponseImpl.this.asyncIOWriter.write((AtmosphereResponse)AtmosphereResponseImpl.this, new String(chars, offset, lenght));
            }
            catch (IOException e) {
                AtmosphereResponseImpl.this.handleException(e);
                throw new RuntimeException(e);
            }
            finally {
                AtmosphereResponseImpl.this.forceAsyncIOWriter = b;
            }
        }

        @Override
        public void write(char[] chars) {
            boolean b = AtmosphereResponseImpl.this.forceAsyncIOWriter;
            try {
                AtmosphereResponseImpl.this.validAsyncIOWriter();
                AtmosphereResponseImpl.this.writeStatusAndHeaders();
                AtmosphereResponseImpl.this.forceAsyncIOWriter = false;
                AtmosphereResponseImpl.this.asyncIOWriter.write((AtmosphereResponse)AtmosphereResponseImpl.this, new String(chars));
            }
            catch (IOException e) {
                AtmosphereResponseImpl.this.handleException(e);
                throw new RuntimeException(e);
            }
            finally {
                AtmosphereResponseImpl.this.forceAsyncIOWriter = b;
            }
        }

        @Override
        public void write(String s, int offset, int lenght) {
            boolean b = AtmosphereResponseImpl.this.forceAsyncIOWriter;
            try {
                AtmosphereResponseImpl.this.validAsyncIOWriter();
                AtmosphereResponseImpl.this.writeStatusAndHeaders();
                AtmosphereResponseImpl.this.forceAsyncIOWriter = false;
                AtmosphereResponseImpl.this.asyncIOWriter.write((AtmosphereResponse)AtmosphereResponseImpl.this, s.substring(offset, lenght));
            }
            catch (IOException e) {
                AtmosphereResponseImpl.this.handleException(e);
                throw new RuntimeException(e);
            }
            finally {
                AtmosphereResponseImpl.this.forceAsyncIOWriter = b;
            }
        }

        @Override
        public void write(String s) {
            boolean b = AtmosphereResponseImpl.this.forceAsyncIOWriter;
            try {
                AtmosphereResponseImpl.this.validAsyncIOWriter();
                AtmosphereResponseImpl.this.writeStatusAndHeaders();
                AtmosphereResponseImpl.this.forceAsyncIOWriter = false;
                AtmosphereResponseImpl.this.asyncIOWriter.write((AtmosphereResponse)AtmosphereResponseImpl.this, s);
            }
            catch (IOException e) {
                AtmosphereResponseImpl.this.handleException(e);
                throw new RuntimeException(e);
            }
            finally {
                AtmosphereResponseImpl.this.forceAsyncIOWriter = b;
            }
        }

        @Override
        public void flush() {
            if (!AtmosphereResponseImpl.this.validFlushOrClose()) {
                return;
            }
            boolean b = AtmosphereResponseImpl.this.forceAsyncIOWriter;
            try {
                AtmosphereResponseImpl.this.writeStatusAndHeaders();
                AtmosphereResponseImpl.this.forceAsyncIOWriter = false;
                AtmosphereResponseImpl.this.asyncIOWriter.flush(AtmosphereResponseImpl.this);
            }
            catch (IOException e) {
                AtmosphereResponseImpl.this.handleException(e);
            }
            finally {
                AtmosphereResponseImpl.this.forceAsyncIOWriter = b;
            }
        }

        @Override
        public void close() {
            if (!AtmosphereResponseImpl.this.validFlushOrClose() || AtmosphereResponseImpl.this.asyncIOWriter instanceof KeepOpenStreamAware) {
                return;
            }
            boolean b = AtmosphereResponseImpl.this.forceAsyncIOWriter;
            AtmosphereResponseImpl.this.forceAsyncIOWriter = false;
            try {
                AtmosphereResponseImpl.this.asyncIOWriter.close(AtmosphereResponseImpl.this);
            }
            catch (IOException e) {
                AtmosphereResponseImpl.this.handleException(e);
            }
            finally {
                AtmosphereResponseImpl.this.forceAsyncIOWriter = b;
            }
        }
    }

    private final class Stream
    extends ServletOutputStream {
        private boolean buffering;

        Stream(boolean buffering) {
            this.buffering = buffering;
        }

        @Override
        public void write(int i) throws IOException {
            this.write(new byte[]{(byte)i});
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            boolean b = AtmosphereResponseImpl.this.forceAsyncIOWriter;
            try {
                AtmosphereResponseImpl.this.validAsyncIOWriter();
                AtmosphereResponseImpl.this.writeStatusAndHeaders();
                AtmosphereResponseImpl.this.forceAsyncIOWriter = false;
                if (this.buffering && !AtmosphereResponseImpl.this.completed()) {
                    AtmosphereResponseImpl.this.writeWithBuffering(bytes);
                } else {
                    AtmosphereResponseImpl.this.asyncIOWriter.write((AtmosphereResponse)AtmosphereResponseImpl.this, bytes);
                }
            }
            catch (IOException e) {
                AtmosphereResponseImpl.this.handleException(e);
                throw e;
            }
            finally {
                AtmosphereResponseImpl.this.forceAsyncIOWriter = b;
            }
        }

        @Override
        public void write(byte[] bytes, int start, int offset) throws IOException {
            boolean b = AtmosphereResponseImpl.this.forceAsyncIOWriter;
            try {
                AtmosphereResponseImpl.this.validAsyncIOWriter();
                AtmosphereResponseImpl.this.writeStatusAndHeaders();
                AtmosphereResponseImpl.this.forceAsyncIOWriter = false;
                if (this.buffering && !AtmosphereResponseImpl.this.completed()) {
                    byte[] copy = new byte[offset];
                    System.arraycopy(bytes, start, copy, 0, offset);
                    AtmosphereResponseImpl.this.writeWithBuffering(copy);
                } else {
                    AtmosphereResponseImpl.this.asyncIOWriter.write(AtmosphereResponseImpl.this, bytes, start, offset);
                }
            }
            catch (IOException e) {
                AtmosphereResponseImpl.this.handleException(e);
                throw e;
            }
            finally {
                AtmosphereResponseImpl.this.forceAsyncIOWriter = b;
            }
        }

        @Override
        public void flush() throws IOException {
            if (!AtmosphereResponseImpl.this.validFlushOrClose()) {
                return;
            }
            AtmosphereResponseImpl.this.writeStatusAndHeaders();
            boolean b = AtmosphereResponseImpl.this.forceAsyncIOWriter;
            AtmosphereResponseImpl.this.forceAsyncIOWriter = false;
            try {
                AtmosphereResponseImpl.this.asyncIOWriter.flush(AtmosphereResponseImpl.this);
            }
            catch (IOException e) {
                AtmosphereResponseImpl.this.handleException(e);
                throw e;
            }
            finally {
                AtmosphereResponseImpl.this.forceAsyncIOWriter = b;
            }
        }

        @Override
        public void close() throws IOException {
            AtmosphereResponseImpl.this.onComplete();
            if (!AtmosphereResponseImpl.this.validFlushOrClose() || AtmosphereResponseImpl.this.asyncIOWriter instanceof KeepOpenStreamAware) {
                return;
            }
            boolean b = AtmosphereResponseImpl.this.forceAsyncIOWriter;
            AtmosphereResponseImpl.this.forceAsyncIOWriter = false;
            try {
                if (this.buffering && !AtmosphereResponseImpl.this.completed()) {
                    AtmosphereResponseImpl.this.writeWithBuffering(null);
                }
                AtmosphereResponseImpl.this.asyncIOWriter.close(AtmosphereResponseImpl.this);
            }
            catch (IOException e) {
                AtmosphereResponseImpl.this.handleException(e);
                throw e;
            }
            finally {
                AtmosphereResponseImpl.this.forceAsyncIOWriter = b;
            }
        }
    }

    public static final class Builder
    implements AtmosphereResponse.Builder {
        private AsyncIOWriter asyncIOWriter;
        private int status = 200;
        private String statusMessage = "OK";
        private AtmosphereRequest atmosphereRequest;
        private HttpServletResponse atmosphereResponse = AtmosphereResponseImpl.access$800();
        private AtomicBoolean writeStatusAndHeader = new AtomicBoolean(true);
        private final Map<String, String> headers = new HashMap<String, String>();
        private boolean destroyable = true;

        @Override
        public Builder destroyable(boolean isRecyclable) {
            this.destroyable = isRecyclable;
            return this;
        }

        @Override
        public Builder asyncIOWriter(AsyncIOWriter asyncIOWriter) {
            this.asyncIOWriter = asyncIOWriter;
            return this;
        }

        @Override
        public Builder status(int status) {
            this.status = status;
            return this;
        }

        @Override
        public Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public Builder request(AtmosphereRequest atmosphereRequest) {
            this.atmosphereRequest = atmosphereRequest;
            return this;
        }

        @Override
        public AtmosphereResponse build() {
            return new AtmosphereResponseImpl(this);
        }

        @Override
        public Builder header(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        @Override
        public Builder writeHeader(boolean writeStatusAndHeader) {
            this.writeStatusAndHeader.set(writeStatusAndHeader);
            return this;
        }

        @Override
        public Builder response(HttpServletResponse res) {
            this.atmosphereResponse = res;
            return this;
        }
    }
}

