/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere.util;

import io.netty.channel.Channel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Utils {
    public static IOException REMOTELY_CLOSED = new IOException("Connection remotely closed");
    private static NoAlloc NO_ALLOC = new NoAlloc();

    public Utils() {
        REMOTELY_CLOSED.setStackTrace(new StackTraceElement[0]);
    }

    public static IOException ioExceptionForChannel(Channel channel, String uuid) {
        IOException ioe = new IOException(channel + ": content already processed for " + uuid);
        ioe.setStackTrace(new StackTraceElement[0]);
        return ioe;
    }

    public static URLClassLoader createURLClassLoader(String dirPath) throws IOException {
        URL[] urls;
        String path;
        URL classesURL;
        URL appRoot;
        String separator;
        if (!(dirPath.endsWith("/") || dirPath.endsWith(".war") || dirPath.endsWith(".jar"))) {
            dirPath = dirPath + File.separator;
        }
        String string = separator = System.getProperty("os.name").toLowerCase().startsWith("win") ? "/" : "//";
        if (dirPath != null && (dirPath.endsWith(".war") || dirPath.endsWith(".jar"))) {
            File file = new File(dirPath);
            appRoot = new URL("jar:file:" + separator + file.getCanonicalPath().replace('\\', '/') + "!/");
            classesURL = new URL("jar:file:" + separator + file.getCanonicalPath().replace('\\', '/') + "!/WEB-INF/classes/");
            path = Utils.expand(appRoot);
        } else {
            path = dirPath;
            classesURL = new URL("file://" + path + "WEB-INF/classes/");
            appRoot = new URL("file://" + path);
        }
        String absolutePath = new File(path).getAbsolutePath();
        File libFiles = new File(absolutePath + File.separator + "WEB-INF" + File.separator + "lib");
        int arraySize = 4;
        if (libFiles.exists() && libFiles.isDirectory()) {
            urls = new URL[libFiles.listFiles().length + arraySize];
            for (int i = 0; i < libFiles.listFiles().length; ++i) {
                urls[i] = new URL("jar:file:" + separator + libFiles.listFiles()[i].toString().replace('\\', '/') + "!/");
            }
        } else {
            urls = new URL[arraySize];
        }
        urls[urls.length - 1] = classesURL;
        urls[urls.length - 2] = appRoot;
        urls[urls.length - 3] = new URL("file://" + path + "/WEB-INF/classes/");
        urls[urls.length - 4] = new URL("file://" + path);
        return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
    }

    public static String expand(URL jar) throws IOException {
        return Utils.expand(jar, System.getProperty("java.io.tmpdir"));
    }

    public static String expand(URL jar, String workFolder) throws IOException {
        int slash;
        int period;
        String pathname = jar.toString().replace('\\', '/');
        if (pathname.endsWith("!/")) {
            pathname = pathname.substring(0, pathname.length() - 2);
        }
        if ((period = pathname.lastIndexOf(46)) >= pathname.length() - 4) {
            pathname = pathname.substring(0, period);
        }
        if ((slash = pathname.lastIndexOf(47)) >= 0) {
            pathname = pathname.substring(slash + 1);
        }
        return Utils.expand(jar, pathname, workFolder);
    }

    public static String expand(URL jar, String pathname, String dirname) throws IOException {
        File appBase = new File(dirname);
        File docBase = new File(appBase, pathname);
        if (!docBase.mkdir()) {
            throw new IllegalStateException(String.format("Unable to create directory: %s", docBase.getAbsolutePath()));
        }
        JarURLConnection juc = (JarURLConnection)jar.openConnection();
        juc.setUseCaches(false);
        JarFile jarFile = null;
        InputStream input = null;
        try {
            jarFile = juc.getJarFile();
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                File parent;
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                int last = name.lastIndexOf(47);
                if (last >= 0 && !(parent = new File(docBase, name.substring(0, last))).mkdirs()) {
                    throw new IllegalStateException(String.format("Unable to create directory: %s", parent.getAbsolutePath()));
                }
                if (name.endsWith("/")) continue;
                input = jarFile.getInputStream(jarEntry);
                Utils.expand(input, docBase, name);
                input.close();
                input = null;
            }
        }
        catch (IOException e) {
            Utils.deleteDir(docBase);
            throw e;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable throwable) {}
                input = null;
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable) {}
                jarFile = null;
            }
        }
        return docBase.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void expand(InputStream input, File docBase, String name) throws IOException {
        File file = new File(docBase, name);
        FilterOutputStream output = null;
        try {
            int n;
            output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer)) > 0) {
                ((BufferedOutputStream)output).write(buffer, 0, n);
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean deleteDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                Utils.deleteDir(file);
                continue;
            }
            if (file.delete()) continue;
            throw new IllegalStateException(String.format("Unable to delete file: %s", file.getAbsolutePath()));
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File src, File dest) {
        boolean result = true;
        String[] files = null;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length && result; ++i) {
            File fileSrc = new File(src, files[i]);
            File fileDest = new File(dest, files[i]);
            if (fileSrc.isDirectory()) {
                result = Utils.copy(fileSrc, fileDest);
                continue;
            }
            FileChannel ic = null;
            AbstractInterruptibleChannel oc = null;
            try {
                ic = new FileInputStream(fileSrc).getChannel();
                oc = new FileOutputStream(fileDest).getChannel();
                ic.transferTo(0L, ic.size(), (WritableByteChannel)((Object)oc));
                continue;
            }
            catch (IOException e) {
                result = false;
                continue;
            }
            finally {
                if (ic != null) {
                    try {
                        ic.close();
                    }
                    catch (IOException iOException) {}
                }
                if (oc != null) {
                    try {
                        oc.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }

    public static String id(Channel channel) {
        InetSocketAddress addr = (InetSocketAddress)channel.localAddress();
        return addr.getAddress().getHostAddress() + "::" + addr.getPort();
    }

    private static class NoAlloc {
        private NoAlloc() {
        }

        public String toString() {
            return "config.noInternalAlloc == true";
        }
    }
}

