/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.nettosphere.ChannelWriter;
import org.atmosphere.nettosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedWriter
extends ChannelWriter {
    private static final Logger logger = LoggerFactory.getLogger(ChunkedWriter.class);
    private final ByteBuf END = Unpooled.wrappedBuffer((byte[])ENDCHUNK);
    private final ByteBuf DELIMITER = Unpooled.wrappedBuffer((byte[])CHUNK_DELIMITER);
    private final AtomicBoolean headerWritten = new AtomicBoolean();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public ChunkedWriter(Channel channel, boolean writeHeader, boolean keepAlive) {
        super(channel, writeHeader, keepAlive);
    }

    private ByteBuf writeHeaders(AtmosphereResponse response) throws UnsupportedEncodingException {
        if (this.writeHeader && !this.headerWritten.getAndSet(true) && response != null) {
            return Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])this.constructStatusAndHeaders(response, -1).getBytes("UTF-8")));
        }
        return Unpooled.EMPTY_BUFFER;
    }

    private ByteBuf writeHeadersForHttp(AtmosphereResponse response) throws UnsupportedEncodingException {
        if (this.writeHeader && !this.headerWritten.getAndSet(true) && response != null) {
            return Unpooled.wrappedBuffer((byte[])this.constructStatusAndHeaders(response, -1).getBytes("UTF-8"));
        }
        return Unpooled.EMPTY_BUFFER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(final AtmosphereResponse response) throws IOException {
        if (!this.channel.isOpen() || this.doneProcessing.get()) {
            return;
        }
        ByteBuf writeBuffer = this.writeHeadersForHttp(response);
        if (writeBuffer.capacity() > 0 && response != null) {
            try {
                this.lock.writeLock().lock();
                this.channel.writeAndFlush((Object)writeBuffer).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        ChunkedWriter.this.prepareForClose(response);
                    }
                });
                this.channel.flush();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        try {
            this.lock.writeLock().lock();
            this.prepareForClose(response);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void prepareForClose(AtmosphereResponse response) throws UnsupportedEncodingException {
        AtmosphereResource r;
        AtmosphereResource atmosphereResource = r = response != null ? response.resource() : null;
        if (r == null || r.isSuspended() && !r.isResumed()) {
            this.keepAlive = false;
        }
        this._close(response);
    }

    void _close(AtmosphereResponse response) throws UnsupportedEncodingException {
        if (!this.doneProcessing.getAndSet(true) && this.channel.isOpen()) {
            ByteBuf writeBuffer = this.writeHeaders(response);
            writeBuffer = writeBuffer.capacity() != 0 ? Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{writeBuffer, this.END}) : Unpooled.buffer((int)ENDCHUNK.length).writeBytes(ENDCHUNK);
            this.channel.writeAndFlush((Object)writeBuffer).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    logger.trace("Async Closing Done {}", (Object)ChunkedWriter.this.channel);
                    if (!ChunkedWriter.this.keepAlive) {
                        ChunkedWriter.this.channel.close().awaitUninterruptibly();
                    }
                }
            });
        }
    }

    @Override
    public AsyncIOWriter asyncWrite(AtmosphereResponse response, byte[] data, int offset, int length) throws IOException {
        if (length == 0) {
            logger.trace("Data is empty {} => {}", (Object)data, (Object)length);
            return this;
        }
        ByteBuf writeBuffer = this.writeHeaders(response);
        if (this.headerWritten.get()) {
            writeBuffer = writeBuffer.capacity() != 0 ? Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{writeBuffer, Unpooled.wrappedBuffer((byte[])Integer.toHexString(length - offset).getBytes("UTF-8")), this.DELIMITER}) : Unpooled.wrappedBuffer((byte[][])new byte[][]{Integer.toHexString(length - offset).getBytes("UTF-8"), CHUNK_DELIMITER});
        }
        writeBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{writeBuffer, Unpooled.wrappedBuffer((byte[])data, (int)offset, (int)length)});
        if (this.headerWritten.get()) {
            writeBuffer.writeBytes(CHUNK_DELIMITER);
        }
        try {
            this.lock.writeLock().lock();
            if (this.doneProcessing.get() && !response.resource().getAtmosphereConfig().framework().isDestroyed()) {
                throw Utils.ioExceptionForChannel(this.channel, response.uuid());
            }
            this.channel.writeAndFlush((Object)writeBuffer);
        }
        catch (IOException ex) {
            logger.warn("", (Throwable)ex);
            throw ex;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }
}

