/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.Meteor;
import org.atmosphere.handler.AnnotatedProxy;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.inject.InjectableObjectFactory;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static boolean RUNNING_TEST = false;
    private static boolean JDK_11_PLUS;
    private static Logger LOGGER;

    public static boolean webSocketEnabled(HttpServletRequest request) {
        boolean allowWebSocketWithoutHeaders;
        if (Utils.closeMessage(request) || !Utils.webSocketQueryStringPresentOrNull(request)) {
            return false;
        }
        boolean bl = allowWebSocketWithoutHeaders = request.getHeader("X-Atmosphere-WebSocket-Proxy") != null;
        if (allowWebSocketWithoutHeaders) {
            return true;
        }
        return Utils.rawWebSocket(request);
    }

    public static boolean rawWebSocket(HttpServletRequest request) {
        Enumeration connection = request.getHeaders("Connection");
        if (connection == null || !connection.hasMoreElements()) {
            connection = request.getHeaders("connection");
        }
        if (connection != null && connection.hasMoreElements()) {
            String[] e;
            for (String upgrade : e = ((String)connection.nextElement()).split(",")) {
                if (!upgrade.trim().equalsIgnoreCase("Upgrade")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean firefoxWebSocketEnabled(HttpServletRequest request) {
        return Utils.webSocketEnabled(request) && request.getHeader("X-atmo-protocol") != null && request.getHeader("X-atmo-protocol").equals("true") && request.getHeader("User-Agent") != null && request.getHeader("User-Agent").toLowerCase().contains("firefox");
    }

    public static boolean twoConnectionsTransport(AtmosphereResource.TRANSPORT t) {
        switch (t) {
            case JSONP: 
            case LONG_POLLING: 
            case STREAMING: 
            case SSE: 
            case POLLING: 
            case HTMLFILE: {
                return true;
            }
        }
        return false;
    }

    public static boolean webSocketQueryStringPresentOrNull(HttpServletRequest request) {
        String transport = request.getHeader("X-Atmosphere-Transport");
        if (transport == null) {
            return true;
        }
        return transport.equalsIgnoreCase("websocket");
    }

    public static boolean resumableTransport(AtmosphereResource.TRANSPORT t) {
        switch (t) {
            case JSONP: 
            case LONG_POLLING: {
                return true;
            }
        }
        return false;
    }

    public static boolean pollableTransport(AtmosphereResource.TRANSPORT t) {
        switch (t) {
            case POLLING: 
            case CLOSE: 
            case AJAX: {
                return true;
            }
        }
        return false;
    }

    public static boolean pushMessage(AtmosphereResource.TRANSPORT t) {
        switch (t) {
            case POLLING: 
            case AJAX: 
            case UNDEFINED: {
                return true;
            }
        }
        return false;
    }

    public static boolean atmosphereProtocol(AtmosphereRequest r) {
        String p = r.getHeader("X-atmo-protocol");
        return Boolean.parseBoolean(p);
    }

    public static boolean webSocketMessage(AtmosphereResource r) {
        AtmosphereRequest request = ((AtmosphereResourceImpl)r).getRequest(false);
        return request.getAttribute(FrameworkConfig.WEBSOCKET_MESSAGE) != null;
    }

    public static boolean properProtocol(HttpServletRequest request) {
        boolean isWebSocket;
        Enumeration connection = request.getHeaders("Connection");
        if (connection == null || !connection.hasMoreElements()) {
            connection = request.getHeaders("connection");
        }
        boolean isOK = false;
        boolean bl = isWebSocket = request.getHeader("sec-websocket-version") != null || request.getHeader("Sec-WebSocket-Draft") != null;
        if (connection != null && connection.hasMoreElements()) {
            String[] e;
            for (String upgrade : e = ((String)connection.nextElement()).split(",")) {
                if (!upgrade.trim().equalsIgnoreCase("upgrade")) continue;
                isOK = true;
                break;
            }
        }
        return !isWebSocket || isOK;
    }

    public static AtmosphereResource websocketResource(AtmosphereResource r) {
        AtmosphereResource resource;
        String parentUUID = (String)((AtmosphereResourceImpl)r).getRequest(false).getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
        if (parentUUID != null && (resource = r.getAtmosphereConfig().resourcesFactory().find(parentUUID)) != null) {
            r = resource;
        }
        return r;
    }

    public static boolean closeMessage(HttpServletRequest request) {
        String s = request.getHeader("X-Atmosphere-Transport");
        return s != null && s.equalsIgnoreCase("close");
    }

    public static Object invoke(Object proxiedInstance, Method m, Object o) {
        if (m != null) {
            try {
                Object[] objectArray;
                if (o == null || m.getParameterTypes().length == 0) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = o;
                }
                return m.invoke(proxiedInstance, objectArray);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        LOGGER.trace("No Method Mapped for {}", o);
        return null;
    }

    public static void inject(AtmosphereResource r) throws IllegalAccessException {
        AtmosphereConfig config = r.getAtmosphereConfig();
        if (config.properties().get(FrameworkConfig.NEED_RUNTIME_INJECTION) == null) {
            return;
        }
        AtmosphereObjectFactory injectableFactory = config.framework().objectFactory();
        if (!InjectableObjectFactory.class.isAssignableFrom(injectableFactory.getClass())) {
            return;
        }
        Object injectIn = Utils.injectWith(r);
        if (injectIn != null) {
            Utils.inject(injectIn, injectIn.getClass(), r);
        }
    }

    public static void inject(Object object, Class<?> clazz, AtmosphereResource r) throws IllegalAccessException {
        ((InjectableObjectFactory)r.getAtmosphereConfig().framework().objectFactory()).requestScoped(object, clazz, r);
    }

    public static void inject(Object object, Class<?> clazz, AtmosphereConfig config) throws IllegalAccessException {
        ((InjectableObjectFactory)config.framework().objectFactory()).requestScoped(object, clazz);
    }

    private static Object injectWith(AtmosphereResource r) {
        AtmosphereHandler h = r.getAtmosphereHandler();
        if (AtmosphereFramework.REFLECTOR_ATMOSPHEREHANDLER.getClass().isAssignableFrom(h.getClass())) {
            WebSocket w = ((AtmosphereResourceImpl)r).webSocket();
            if (w != null && w.webSocketHandler() instanceof WebSocketProcessor.WebSocketHandlerProxy) {
                return ((WebSocketProcessor.WebSocketHandlerProxy)w.webSocketHandler()).proxied();
            }
            return null;
        }
        return Utils.injectWith(h);
    }

    private static Object injectWith(AtmosphereHandler h) {
        if (AnnotatedProxy.class.isAssignableFrom(h.getClass())) {
            return ((AnnotatedProxy)h).target();
        }
        if (ReflectorServletProcessor.class.isAssignableFrom(h.getClass())) {
            return ((ReflectorServletProcessor)h).getServlet();
        }
        return h;
    }

    public static Set<Field> getInheritedPrivateFields(Class<?> type) {
        HashSet<Field> result = new HashSet<Field>();
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field field : i.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                result.add(field);
            }
        }
        return result;
    }

    public static Set<Method> getInheritedPrivateMethod(Class<?> type) {
        HashSet<Method> result = new HashSet<Method>();
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Method m : i.getDeclaredMethods()) {
                if (m.isSynthetic()) continue;
                result.add(m);
            }
        }
        return result;
    }

    public static boolean requestScopedInjection(AtmosphereConfig config, AtmosphereHandler h) {
        AtmosphereObjectFactory injectableFactory = config.framework().objectFactory();
        if (!InjectableObjectFactory.class.isAssignableFrom(injectableFactory.getClass())) {
            return false;
        }
        try {
            Object obj = Utils.injectWith(h);
            return obj != null && ((InjectableObjectFactory)config.framework().objectFactory()).needRequestScoped(obj.getClass());
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            return false;
        }
    }

    public static boolean requestScopedInjection(AtmosphereConfig config, Object o) {
        AtmosphereObjectFactory injectableFactory = config.framework().objectFactory();
        if (!InjectableObjectFactory.class.isAssignableFrom(injectableFactory.getClass())) {
            return false;
        }
        try {
            return ((InjectableObjectFactory)config.framework().objectFactory()).needRequestScoped(o.getClass());
        }
        catch (Exception var4) {
            LOGGER.error("", (Throwable)var4);
            return false;
        }
    }

    public static void destroyMeteor(AtmosphereRequest req) {
        try {
            Object o = req.getAttribute(AtmosphereResourceImpl.METEOR);
            if (o != null && Meteor.class.isAssignableFrom(o.getClass())) {
                ((Meteor)o).destroy();
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Meteor resume exception: Cannot resume an already resumed/cancelled request", (Throwable)ex);
        }
    }

    public static String pathInfo(AtmosphereRequest request) {
        String pathInfo = null;
        try {
            pathInfo = request.getPathInfo();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        String path = pathInfo != null ? request.getServletPath() + pathInfo : request.getServletPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        return path;
    }

    public static boolean isRunningTest() {
        return RUNNING_TEST;
    }

    public static boolean isUnderJDK11AndUp() {
        return JDK_11_PLUS;
    }

    static {
        try {
            Class.forName("org.testng.TestNG");
            RUNNING_TEST = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        JDK_11_PLUS = false;
        try {
            Class.forName("java.net.http.HttpClient");
            JDK_11_PLUS = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        LOGGER = LoggerFactory.getLogger(Utils.class);
    }
}

