/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.patches.patch08131253;

import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterLifeCyclePolicyListener;
import org.primefaces.push.PushRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedBroadcasterCachePushRule
implements PushRule {
    public boolean apply(AtmosphereResource resource) {
        String pathInfo = resource.getRequest().getPathInfo();
        if (pathInfo == null) {
            resource.setBroadcaster(BroadcasterFactory.getDefault().lookup((Object)"/*"));
            return true;
        }
        final Broadcaster b = BroadcasterFactory.getDefault().lookup((Object)pathInfo, true);
        b.addBroadcasterLifeCyclePolicyListener(new BroadcasterLifeCyclePolicyListener(){
            private final Logger logger = LoggerFactory.getLogger(BroadcasterLifeCyclePolicyListener.class);

            public void onEmpty() {
                this.logger.trace("onEmpty {}", (Object)b.getID());
            }

            public void onIdle() {
                this.logger.trace("onIdle {}", (Object)b.getID());
            }

            public void onDestroy() {
                this.logger.trace("onDestroy {}", (Object)b.getID());
            }
        });
        resource.setBroadcaster(b);
        return true;
    }
}

