/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.patches.patch10121186;

import java.io.IOException;
import javax.servlet.ServletException;
import org.atmosphere.config.service.AsyncSupportService;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.jboss.servlet.http.HttpEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AsyncSupportService
public class JBossAPRAsyncSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JBossAPRAsyncSupport.class);
    public static final String HTTP_EVENT = "HttpEvent";
    private static final String SUSPENDED = JBossAPRAsyncSupport.class.getName() + ".suspended";
    private static final IllegalStateException unableToDetectComet = new IllegalStateException(JBossAPRAsyncSupport.unableToDetectComet());
    private final Boolean closeConnectionOnInputStream;

    public JBossAPRAsyncSupport(AtmosphereConfig config) {
        super(config);
        String b = config.getInitParameter("org.atmosphere.container.TomcatCometSupport.discardEOF");
        this.closeConnectionOnInputStream = b == null ? true : Boolean.parseBoolean(b.toString());
    }

    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        HttpEvent event = (HttpEvent)req.getAttribute(HTTP_EVENT);
        if (event == null) {
            throw unableToDetectComet;
        }
        logger.trace("Event Type {} for {}", (Object)event.getType(), (Object)req.getQueryString());
        Action action = null;
        if (event.getType() == HttpEvent.EventType.BEGIN) {
            action = this.suspended(req, res);
            if (action.type() == Action.TYPE.SUSPEND) {
                try {
                    if (action.timeout() != -1L) {
                        event.setTimeout((int)action.timeout());
                    } else {
                        event.setTimeout(Integer.MAX_VALUE);
                    }
                    req.setAttribute(SUSPENDED, (Object)true);
                }
                catch (UnsupportedOperationException ex) {}
            } else if (action.type() == Action.TYPE.RESUME) {
                event.close();
            } else {
                event.close();
            }
        } else if (event.getType() == HttpEvent.EventType.READ) {
            logger.debug("Receiving bytes, unable to process them.");
        } else if (event.getType() == HttpEvent.EventType.EOF || event.getType() == HttpEvent.EventType.ERROR || event.getType() == HttpEvent.EventType.END) {
            if (req.getAttribute(SUSPENDED) != null && this.closeConnectionOnInputStream.booleanValue()) {
                req.setAttribute(SUSPENDED, null);
                action = this.cancelled(req, res);
            } else {
                event.close();
            }
        } else if (event.getType() == HttpEvent.EventType.TIMEOUT) {
            action = this.timedout(req, res);
            event.close();
        }
        return action;
    }

    public Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = super.cancelled(req, res);
        if (req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity") != null && (Long)Long.class.cast(req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity")) == -1L) {
            HttpEvent event = (HttpEvent)req.getAttribute(HTTP_EVENT);
            if (event == null) {
                return action;
            }
            event.close();
        }
        return action;
    }

    public void action(AtmosphereResourceImpl actionEvent) {
        super.action(actionEvent);
        if (actionEvent.action().type() == Action.TYPE.RESUME && actionEvent.isInScope()) {
            try {
                HttpEvent event = (HttpEvent)actionEvent.getRequest().getAttribute(HTTP_EVENT);
                if (this.config.getInitParameter("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive") == null || this.config.getInitParameter("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive").equalsIgnoreCase("false")) {
                    event.close();
                }
            }
            catch (IOException ex) {
                logger.debug("", (Throwable)ex);
            }
        }
    }

    private static String unableToDetectComet() {
        StringBuilder sb = new StringBuilder();
        sb.append("JBoss failed to detect this is a Comet application because the APR Connector is not enabled. ");
        sb.append("\nMake sure atmosphere-compat-jboss.jar is not under your WEB-INF/lib and ");
        sb.append("\nthere is no context.xml under WEB-INF");
        return sb.toString();
    }
}

