/*
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2007-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 */
package org.atmosphere.grizzly;

import com.sun.grizzly.http.servlet.ServletAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.jersey.api.core.ClasspathResourceConfig;
import java.io.File;
import org.atmosphere.container.GrizzlyCometSupport;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.AtmosphereServlet.AtmosphereConfig;
import org.atmosphere.handler.ReflectorServletProcessor;

/**
 * Simple {@link GrizzlyAdapter} that can be used to embed Atmosphere using
 * Grizzly.
 * 
 * @author Jeanfrancois Arcand
 */
public class AtmosphereAdapter extends ServletAdapter{

    private String resourcePackage = "";

    private boolean isJersey = true;

    private final AtmosphereServlet as = new AtmosphereServlet(){
        /**
         * Auto detect the underlying Servlet Container we are running on.
         */
        @Override
        protected void autoDetectContainer(){
            config = new AtmosphereConfig();
            cometSupport = new GrizzlyCometSupport(config);
        }   
    };

    @Override
    public void start(){
        if (isJersey){
            ReflectorServletProcessor rsp = new ReflectorServletProcessor();
            rsp.setServletClass("com.sun.jersey.spi.container.servlet.ServletContainer");
            addAtmosphereHandler("/*",rsp);
        }
        addInitParameter("com.sun.jersey.config.property.packages", resourcePackage);
        addInitParameter(ClasspathResourceConfig.PROPERTY_CLASSPATH,
                         System.getProperty("java.class.path").replace(File.pathSeparatorChar, ';'));
        setServletInstance(as);
        super.start();
    }


    /**
     * Add an {@link AtmosphereHandler}
     */
    public void addAtmosphereHandler(String path,AtmosphereHandler ah){
        isJersey = false;
        as.addAtmosphereHandler(path, ah);
    }

    /**
     * Set the location of web application. This maps to Jersey's
     * "com.sun.jersey.config.property.packages" property.
     *
     * @return the resourcePackage
     */
    public String getResourcePackage() {
        return resourcePackage;
    }

    /**
     * Return the location of web application.
     * @param resourcePackage the resourcePackage to set
     */
    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

}
