/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.grizzly;

import com.sun.grizzly.http.servlet.ServletAdapter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.atmosphere.container.GrizzlyCometSupport;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;

public class AtmosphereAdapter
extends ServletAdapter {
    private String resourcePackage = "";
    private final AtmosphereServlet as = new AtmosphereServlet(){

        protected void autoDetectContainer() {
            this.config = this.newAtmosphereConfig(false);
            this.setUseStreamForFlushingComments(true);
            this.cometSupport = new GrizzlyCometSupport(this.config);
        }

        protected void autoDetectAtmosphereHandlers(ServletContext sc, URLClassLoader c) throws MalformedURLException, URISyntaxException {
            File f;
            try {
                Class.forName("org.atmosphere.spade.AtmosphereSpadeLauncher");
            }
            catch (Exception ex) {
                super.autoDetectAtmosphereHandlers(sc, c);
                return;
            }
            String s = sc.getRealPath("/WEB-INF/classes/");
            if (s == null) {
                URL u = sc.getResource("/WEB-INF/classes/");
                if (u == null) {
                    return;
                }
                s = u.getPath();
            }
            if (!(f = new File(s)).exists()) {
                String trailer = s.substring(0, s.indexOf(sc.getContextPath()));
                f = new File(trailer + sc.getContextPath() + "/WEB-INF/classes/");
            }
            if (f.isDirectory()) {
                this.getFiles(f);
                for (String className : this.possibleAtmosphereHandlersCandidate) {
                    try {
                        className = className.replace('\\', '/');
                        className = className.substring(className.indexOf("/WEB-INF/classes/") + "/WEB-INF/classes/".length(), className.lastIndexOf(".")).replace('/', '.');
                        AtmosphereHandler g = (AtmosphereHandler)c.loadClass(className).newInstance();
                        logger.info("Sucessfully loaded " + g + " mapped to context-path " + g.getClass().getSimpleName());
                        this.atmosphereHandlers.put("/" + g.getClass().getSimpleName(), new AtmosphereServlet.AtmosphereHandlerWrapper(g, (Broadcaster)c.loadClass(this.broadcasterClassName).newInstance()));
                    }
                    catch (Throwable t) {
                        logger.finest(className + " is not a AtmosphereHandler");
                    }
                }
            }
            logger.info("Atmosphere using Broadcaster " + this.broadcasterClassName);
        }
    };

    public void start() {
        this.addInitParameter("com.sun.jersey.config.property.packages", this.resourcePackage);
        this.setServletInstance((Servlet)this.as);
        super.start();
    }

    public void setUseStreamForFlushingComments(boolean useStreaming) {
        this.as.setUseStreamForFlushingComments(useStreaming);
    }

    public void addAtmosphereHandler(String path, AtmosphereHandler ah) {
        this.as.addAtmosphereHandler(path, ah);
    }

    public String getResourcePackage() {
        return this.resourcePackage;
    }

    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }
}

