/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.grizzly;

import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.arp.AsyncFilter;
import com.sun.grizzly.comet.CometAsyncFilter;
import com.sun.grizzly.http.embed.GrizzlyWebServer;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import java.io.IOException;
import java.net.URI;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.grizzly.AtmosphereAdapter;
import org.atmosphere.util.LoggerUtils;

public final class AtmosphereSpadeServer {
    private final GrizzlyWebServer gws;
    private final AtmosphereAdapter aa = new AtmosphereAdapter();
    private boolean defaultToJersey = true;

    private AtmosphereSpadeServer(int port, boolean secure) {
        this.gws = new GrizzlyWebServer(port, ".", secure);
        this.gws.getSelectorThread().setDisplayConfiguration(false);
        this.gws.addAsyncFilter((AsyncFilter)new CometAsyncFilter());
    }

    public static AtmosphereSpadeServer build(String u) {
        return AtmosphereSpadeServer.build(u, "");
    }

    public static AtmosphereSpadeServer build(String u, String resourcesPackage) {
        return AtmosphereSpadeServer.build(u, resourcesPackage, null);
    }

    public static AtmosphereSpadeServer build(String u, SSLConfig sslConfig) {
        return AtmosphereSpadeServer.build(u, null, sslConfig);
    }

    public static AtmosphereSpadeServer build(String u, String resourcesPackage, SSLConfig sslConfig) {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        URI uri = URI.create(u);
        String scheme = uri.getScheme();
        if (!scheme.startsWith("http")) {
            throw new IllegalArgumentException("The URI scheme, of the URI " + u + ", must be equal (ignoring case) to 'http'");
        }
        int port = uri.getPort() == -1 ? 80 : uri.getPort();
        String path = uri.getPath();
        if (path == null) {
            throw new IllegalArgumentException("The URI path, of the URI " + uri + ", must be non-null");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("The URI path, of the URI " + uri + ", must be present");
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("The URI path, of the URI " + uri + ". must start with a '/'");
        }
        boolean secure = false;
        if (scheme.equalsIgnoreCase("https")) {
            secure = true;
        }
        AtmosphereSpadeServer a = new AtmosphereSpadeServer(port, secure);
        if (path.length() > 1) {
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            a.aa.setContextPath(path);
        }
        if (resourcesPackage != null) {
            a.aa.setResourcePackage(resourcesPackage);
        }
        if (sslConfig != null) {
            a.setSSLConfig(sslConfig);
        }
        return a;
    }

    private void setSSLConfig(SSLConfig sslConfig) {
        this.gws.setSSLConfig(sslConfig);
    }

    public AtmosphereSpadeServer addAtmosphereHandler(String mapping, AtmosphereHandler h) {
        this.defaultToJersey = false;
        AtmosphereAdapter a = new AtmosphereAdapter();
        a.setServletInstance(this.aa.getServletInstance());
        a.addAtmosphereHandler(mapping, h);
        a.setServletPath(mapping);
        a.setHandleStaticResources(true);
        this.gws.addGrizzlyAdapter((GrizzlyAdapter)a, new String[]{mapping});
        return this;
    }

    public void setResourcePackage(String resourcePackage) {
        this.aa.setResourcePackage(resourcePackage);
    }

    public AtmosphereSpadeServer start() throws IOException {
        LoggerUtils.getLogger().info("AtmosphereSpade Server Started on port: " + this.gws.getSelectorThread().getPort());
        if (this.defaultToJersey) {
            this.aa.setHandleStaticResources(true);
            this.gws.addGrizzlyAdapter((GrizzlyAdapter)this.aa, new String[]{"*"});
        }
        this.gws.start();
        return this;
    }

    public AtmosphereSpadeServer stop() throws IOException {
        this.gws.stop();
        return this;
    }
}

