/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.grizzly;

import com.sun.grizzly.http.servlet.ServletAdapter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.atmosphere.container.GrizzlyCometSupport;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereServlet;

public class AtmosphereAdapter
extends ServletAdapter {
    private String resourcePackage = null;
    private final AtmosphereServlet as = new AtmosphereServlet(){

        protected void autoDetectContainer() {
            this.setUseStreamForFlushingComments(true);
            this.cometSupport = new GrizzlyCometSupport(this.getAtmosphereConfig());
        }

        protected void autoDetectAtmosphereHandlers(ServletContext sc, URLClassLoader c) throws MalformedURLException, URISyntaxException {
            File f;
            try {
                Class.forName("org.atmosphere.spade.AtmosphereSpadeLauncher");
            }
            catch (Exception ex) {
                super.autoDetectAtmosphereHandlers(sc, c);
                return;
            }
            String s = sc.getRealPath("/WEB-INF/classes/");
            if (s == null) {
                URL u = sc.getResource("/WEB-INF/classes/");
                if (u == null) {
                    return;
                }
                s = u.getPath();
            }
            if (!(f = new File(s)).exists()) {
                int index;
                String ctxPath = sc.getContextPath();
                if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                    ctxPath = ctxPath.replace("/", "\\");
                }
                if ((index = s.indexOf(ctxPath)) < 1) {
                    index = s.length();
                }
                String trailer = s.substring(0, index);
                f = new File(trailer + sc.getContextPath() + "/WEB-INF/classes/");
            }
            if (f.isDirectory()) {
                this.getFiles(f);
                for (String className : this.possibleAtmosphereHandlersCandidate) {
                    try {
                        className = className.replace('\\', '/');
                        Class<?> clazz = c.loadClass(className = className.substring(className.indexOf("/WEB-INF/classes/") + "/WEB-INF/classes/".length(), className.lastIndexOf(".")).replace('/', '.'));
                        if (!AtmosphereHandler.class.isAssignableFrom(clazz)) continue;
                        AtmosphereHandler g = (AtmosphereHandler)clazz.newInstance();
                        logger.info("Successfully loaded " + g + " mapped to context-path " + g.getClass().getSimpleName());
                        this.addAtmosphereHandler("/" + g.getClass().getSimpleName(), g);
                    }
                    catch (Throwable t) {
                        logger.finest(className + " is not a AtmosphereHandler");
                    }
                }
            }
        }
    };

    public void start() {
        if (this.resourcePackage != null) {
            this.addInitParameter("com.sun.jersey.config.property.packages", this.resourcePackage);
        }
        this.setServletInstance((Servlet)this.as);
        super.start();
    }

    public void setUseStreamForFlushingComments(boolean useStreaming) {
        this.as.setUseStreamForFlushingComments(useStreaming);
    }

    public void addAtmosphereHandler(String path, AtmosphereHandler ah) {
        this.as.addAtmosphereHandler(path, ah);
    }

    public String getResourcePackage() {
        return this.resourcePackage;
    }

    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }
}

