/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.grizzly;

import com.sun.grizzly.http.servlet.ServletAdapter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.atmosphere.container.GrizzlyCometSupport;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereServlet;

public class AtmosphereAdapter
extends ServletAdapter {
    private String resourcePackage = null;
    private final AtmosphereServlet as = new GrizzlyAtmosphereServlet();

    public void start() {
        if (this.resourcePackage != null) {
            this.addInitParameter("com.sun.jersey.config.property.packages", this.resourcePackage);
        }
        this.setServletInstance((Servlet)this.as);
        super.start();
    }

    public void setUseStreamForFlushingComments(boolean useStreaming) {
        this.as.setUseStreamForFlushingComments(useStreaming);
    }

    public void addAtmosphereHandler(String path, AtmosphereHandler ah) {
        this.as.addAtmosphereHandler(path, ah);
    }

    public String getResourcePackage() {
        return this.resourcePackage;
    }

    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

    private static class GrizzlyAtmosphereServlet
    extends AtmosphereServlet {
        private GrizzlyAtmosphereServlet() {
        }

        protected void autoDetectContainer() {
            this.setUseStreamForFlushingComments(true);
            this.cometSupport = new GrizzlyCometSupport(this.getAtmosphereConfig());
        }

        protected void autoDetectAtmosphereHandlers(ServletContext servletContext, URLClassLoader classLoader) throws MalformedURLException, URISyntaxException {
            File f;
            try {
                Class.forName("org.atmosphere.spade.AtmosphereSpadeLauncher");
            }
            catch (Exception ex) {
                super.autoDetectAtmosphereHandlers(servletContext, classLoader);
                return;
            }
            String realPath = servletContext.getRealPath("/WEB-INF/classes/");
            if (realPath == null) {
                URL u = servletContext.getResource("/WEB-INF/classes/");
                if (u == null) {
                    return;
                }
                realPath = u.getPath();
            }
            if (!(f = new File(realPath)).exists()) {
                int index;
                String ctxPath = servletContext.getContextPath();
                if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                    ctxPath = ctxPath.replace("/", "\\");
                }
                if ((index = realPath.indexOf(ctxPath)) < 1) {
                    index = realPath.length();
                }
                String trailer = realPath.substring(0, index);
                f = new File(trailer + servletContext.getContextPath() + "/WEB-INF/classes/");
            }
            this.loadAtmosphereHandlersFromPath(classLoader, realPath);
        }
    }
}

