/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.pubsub;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.websocket.WebSocketEventListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtmosphereHandlerPubSub
extends AbstractReflectorAtmosphereHandler {
    public void onRequest(AtmosphereResource<HttpServletRequest, HttpServletResponse> r) throws IOException {
        HttpServletRequest req = (HttpServletRequest)r.getRequest();
        HttpServletResponse res = (HttpServletResponse)r.getResponse();
        String method = req.getMethod();
        if ("GET".equalsIgnoreCase(method)) {
            r.addEventListener((AtmosphereResourceEventListener)new WebSocketEventListenerAdapter());
            res.setContentType("text/html;charset=ISO-8859-1");
            Broadcaster b = this.lookupBroadcaster(req.getPathInfo());
            r.setBroadcaster(b);
            if (req.getHeader("X-Atmosphere-Transport").equalsIgnoreCase("long-polling")) {
                req.setAttribute("org.atmosphere.resumeOnBroadcast", (Object)Boolean.TRUE);
                r.suspend(-1L, false);
            } else {
                r.suspend(-1L);
            }
        } else if ("POST".equalsIgnoreCase(method)) {
            Broadcaster b = this.lookupBroadcaster(req.getPathInfo());
            String message = req.getReader().readLine();
            if (message != null && message.indexOf("message") != -1) {
                b.broadcast((Object)message.substring("message=".length()));
            }
        }
    }

    public void destroy() {
    }

    Broadcaster lookupBroadcaster(String pathInfo) {
        String[] decodedPath = pathInfo.split("/");
        Broadcaster b = BroadcasterFactory.getDefault().lookup((Object)decodedPath[decodedPath.length - 1], true);
        return b;
    }
}

