/*
 * Decompiled with CFR 0.152.
 */
package org.webtide.demo.auction;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import org.cometd.Bayeux;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.oort.Oort;
import org.cometd.oort.Seti;
import org.cometd.server.BayeuxService;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuctionChatService
extends BayeuxService {
    private final ConcurrentMap<String, Set<String>> _members = new ConcurrentHashMap();
    private Oort _oort;
    private Seti _seti;

    public AuctionChatService(ServletContext context) {
        super((Bayeux)context.getAttribute("org.cometd.bayeux"), "chat");
        this._oort = (Oort)context.getAttribute("org.cometd.oort.Oort");
        if (this._oort == null) {
            throw new RuntimeException("!org.cometd.oort.Oort");
        }
        this._seti = (Seti)context.getAttribute("org.cometd.oort.Seti");
        if (this._seti == null) {
            throw new RuntimeException("!org.cometd.oort.Seti");
        }
        this.subscribe("/auction/chat/**", "trackMembers");
        this.subscribe("/service/auction/chat", "privateChat");
    }

    public void trackMembers(Client joiner, String channelName, Object data, String messageId) {
        if (data instanceof Object[]) {
            HashSet<String> newMembers;
            HashSet<String> members = (HashSet<String>)this._members.get(channelName);
            if (members == null && (members = (Set)this._members.putIfAbsent(channelName, newMembers = new HashSet<String>())) == null) {
                members = newMembers;
            }
            boolean added = false;
            for (Object user : (Object[])data) {
                added |= members.add(user.toString());
            }
            if (added) {
                Log.info((String)("Members: " + members));
                this.getBayeux().getChannel(channelName, false).publish(this.getClient(), members, messageId);
            }
        } else if (data instanceof Map) {
            String userName;
            HashSet<String> newMembers;
            Set<String> members;
            Map map = (Map)data;
            if (Boolean.TRUE.equals(map.get("join"))) {
                members = (HashSet<String>)this._members.get(channelName);
                if (members == null && (members = (Set)this._members.putIfAbsent(channelName, newMembers = new HashSet<String>())) == null) {
                    members = newMembers;
                }
                userName = (String)map.get("user");
                members.add(userName);
                if (!this._oort.isOort(joiner)) {
                    this._seti.associate(userName, joiner);
                }
                joiner.addListener((ClientListener)new /* Unavailable Anonymous Inner Class!! */);
                Log.info((String)("Members: " + members));
                this.getBayeux().getChannel(channelName, false).publish(this.getClient(), members, messageId);
            }
            if (Boolean.TRUE.equals(map.get("leave"))) {
                members = (Set)this._members.get(channelName);
                if (members == null && (members = (Set)this._members.putIfAbsent(channelName, newMembers = new HashSet())) == null) {
                    members = newMembers;
                }
                userName = (String)map.get("user");
                members.remove(userName);
                Log.info((String)("Members: " + members));
                this.getBayeux().getChannel(channelName, true).publish(this.getClient(), members, messageId);
            }
        }
    }

    public void privateChat(Client source, String channel, Map<String, Object> data, String messageId) {
        String toUid = (String)data.get("peer");
        String toChannel = (String)data.get("room");
        source.deliver(source, toChannel, data, messageId);
        this._seti.sendMessage(toUid, toChannel, data);
    }

    static /* synthetic */ Oort access$000(AuctionChatService x0) {
        return x0._oort;
    }

    static /* synthetic */ Seti access$100(AuctionChatService x0) {
        return x0._seti;
    }
}

