/*
 * Decompiled with CFR 0.152.
 */
package org.webtide.demo.auction;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContext;
import org.cometd.Bayeux;
import org.cometd.BayeuxListener;
import org.cometd.Channel;
import org.cometd.ChannelBayeuxListener;
import org.cometd.ChannelListener;
import org.cometd.Client;
import org.cometd.SubscriptionListener;
import org.cometd.oort.Oort;
import org.cometd.oort.Seti;
import org.cometd.server.BayeuxService;
import org.webtide.demo.auction.Bid;
import org.webtide.demo.auction.Bidder;
import org.webtide.demo.auction.Category;
import org.webtide.demo.auction.Item;
import org.webtide.demo.auction.dao.AuctionDao;
import org.webtide.demo.auction.dao.BidderDao;
import org.webtide.demo.auction.dao.CategoryDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuctionService
extends BayeuxService
implements SubscriptionListener,
ChannelBayeuxListener {
    public static final String AUCTION_ROOT = "/auction/";
    AuctionDao _auctionDao = new AuctionDao();
    BidderDao _bidderDao = new BidderDao();
    CategoryDao _categoryDao = new CategoryDao();
    private Oort _oort;
    private Seti _seti;
    private AtomicInteger _bidders = new AtomicInteger(0);

    public AuctionService(ServletContext context) {
        super((Bayeux)context.getAttribute("org.cometd.bayeux"), "oortion");
        this._oort = (Oort)context.getAttribute("org.cometd.oort.Oort");
        if (this._oort == null) {
            throw new RuntimeException("!org.cometd.oort.Oort");
        }
        this._seti = (Seti)context.getAttribute("org.cometd.oort.Seti");
        if (this._seti == null) {
            throw new RuntimeException("!org.cometd.oort.Seti");
        }
        this._oort.observeChannel("/auction/**");
        this.getBayeux().addListener((BayeuxListener)this);
        this.setSeeOwnPublishes(false);
        this.subscribe("/auction/*", "bids");
        this.subscribe("/service/auction/bid", "bid");
        this.subscribe("/service/auction/bidder", "bidder");
        this.subscribe("/service/auction/search", "search");
        this.subscribe("/service/auction/category", "category");
        this.subscribe("/service/auction/categories", "categories");
    }

    public Bidder bidder(Client source, String channel, String bidder, String messageId) {
        Integer id = this._bidders.incrementAndGet();
        String username = bidder.toLowerCase().replace(" ", "");
        while (this._bidderDao.getBidder(username) != null) {
            username = bidder.toLowerCase().replace(" ", "") + "-" + this._bidders.incrementAndGet();
        }
        Bidder b = new Bidder();
        b.setName(bidder);
        b.setUsername(username);
        this._bidderDao.addBidder(b);
        this._seti.associate(b.getUsername(), source);
        return b;
    }

    public List<Category> categories(Client source, String channel, String bidder, String messageId) {
        return this._categoryDao.getAllCategories();
    }

    public List<Item> search(Client source, String channel, String search, String messageId) {
        return this._categoryDao.findItems(search);
    }

    public List<Item> category(Client source, String channel, Number categoryId, String messageId) {
        return this._categoryDao.getItemsInCategory(Integer.valueOf(categoryId.intValue()));
    }

    public synchronized void bid(Client source, String channel, Map<String, Object> bidMap, String messageId) {
        try {
            Bid highest;
            Integer itemId = ((Number)bidMap.get("itemId")).intValue();
            Double amount = Double.parseDouble(bidMap.get("amount").toString());
            String username = (String)bidMap.get("username");
            Bidder bidder = this._bidderDao.getBidder(username);
            if (bidder != null && ((highest = this._auctionDao.getHighestBid(itemId)) == null || amount > highest.getAmount())) {
                Bid bid = new Bid();
                bid.setItemId(itemId);
                bid.setAmount(amount);
                bid.setBidder(bidder);
                this._auctionDao.saveAuctionBid(bid);
                this.getBayeux().getChannel("/auction/item" + itemId, true).publish(this.getClient(), (Object)bid, messageId);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    public synchronized void bids(Client source, String channel, Map<String, Object> bidMap, String messageId) {
        Integer itemId = ((Number)bidMap.get("itemId")).intValue();
        Double amount = Double.parseDouble(bidMap.get("amount").toString());
        Map bidderMap = (Map)bidMap.get("bidder");
        String username = (String)bidderMap.get("username");
        Bidder bidder = this._bidderDao.getBidder(username);
        if (bidder == null) {
            bidder = new Bidder();
            bidder.setUsername(username);
            bidder.setName((String)bidderMap.get("name"));
            this._bidderDao.addBidder(bidder);
            bidder = this._bidderDao.getBidder(username);
        }
        Bid bid = new Bid();
        bid.setItemId(itemId);
        bid.setAmount(amount);
        bid.setBidder(bidder);
        Bid highest = this._auctionDao.getHighestBid(itemId);
        if (highest == null || amount > highest.getAmount()) {
            this._auctionDao.saveAuctionBid(bid);
        }
    }

    public void subscribed(Client client, Channel channel) {
        Integer itemId;
        Bid highest;
        String itemIdS;
        if (!client.isLocal() && channel.getId().startsWith("/auction/item") && (itemIdS = channel.getId().substring("/auction/item".length())).indexOf(47) < 0 && (highest = this._auctionDao.getHighestBid(itemId = Integer.decode(itemIdS))) != null) {
            client.deliver(this.getClient(), channel.getId(), (Object)highest, null);
        }
    }

    public void unsubscribed(Client client, Channel channel) {
    }

    public void channelAdded(Channel channel) {
        if (channel.getId().startsWith("/auction/item")) {
            channel.addListener((ChannelListener)this);
        }
    }

    public void channelRemoved(Channel channel) {
    }
}

