/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.chat;

import java.io.IOException;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.handler.OnMessage;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.atmosphere.interceptor.BroadcastOnPostAtmosphereInterceptor;
import org.atmosphere.samples.chat.SSEAtmosphereHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereHandlerService(path="/chat", interceptors={AtmosphereResourceLifecycleInterceptor.class, BroadcastOnPostAtmosphereInterceptor.class})
public class SSEAtmosphereHandler
extends OnMessage<String> {
    private final Logger logger = LoggerFactory.getLogger(SSEAtmosphereHandler.class);

    public void onMessage(AtmosphereResponse response, String message) throws IOException {
        String author = message.substring(message.indexOf(":") + 2, message.indexOf(",") - 1);
        String chat = message.substring(message.lastIndexOf(":") + 2, message.length() - 2);
        response.getWriter().write(new Data(author, chat).toString());
    }

    public void onDisconnect(AtmosphereResponse response) throws IOException {
        AtmosphereResourceEvent event = response.resource().getAtmosphereResourceEvent();
        if (event.isCancelled()) {
            this.logger.info("Browser {} unexpectedly disconnected", (Object)response.resource().uuid());
        } else if (event.isClosedByClient()) {
            this.logger.info("Browser {} closed the connection", (Object)response.resource().uuid());
        }
    }
}

