/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.chat;

import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereEvent;
import org.atmosphere.cpr.AtmosphereHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatAtmosphereHandler
implements AtmosphereHandler<HttpServletRequest, HttpServletResponse> {
    private static final String BEGIN_SCRIPT_TAG = "<script type='text/javascript'>\n";
    private static final String END_SCRIPT_TAG = "</script>\n";
    private static final Logger logger = Logger.getLogger("Grizzly");
    private static final long serialVersionUID = -2919167206889576860L;

    public AtmosphereEvent<HttpServletRequest, HttpServletResponse> onEvent(AtmosphereEvent<HttpServletRequest, HttpServletResponse> event) throws IOException {
        HttpServletRequest req = (HttpServletRequest)event.getRequest();
        HttpServletResponse res = (HttpServletResponse)event.getResponse();
        res.setContentType("text/html");
        res.addHeader("Cache-Control", "private");
        res.addHeader("Pragma", "no-cache");
        if (req.getMethod().equalsIgnoreCase("GET")) {
            res.getWriter().write("<!-- Comet is a programming technique that enables web servers to send data to the client without having any need for the client to request it. -->\n");
            res.getWriter().flush();
            event.suspend();
            event.getBroadcaster().broadcast((Object)(BEGIN_SCRIPT_TAG + this.toJsonp(event.getAtmosphereConfig().getWebServerName() + " has suspended a connection from " + req.getRemoteAddr(), "") + END_SCRIPT_TAG));
        } else if (req.getMethod().equalsIgnoreCase("POST")) {
            res.setCharacterEncoding("UTF-8");
            String action = req.getParameterValues("action")[0];
            String name = req.getParameterValues("name")[0];
            if ("login".equals(action)) {
                req.getSession().setAttribute("name", (Object)name);
                event.getBroadcaster().broadcast((Object)(BEGIN_SCRIPT_TAG + this.toJsonp("System Message from " + event.getAtmosphereConfig().getWebServerName(), name + " has joined.") + END_SCRIPT_TAG));
                res.getWriter().write("success");
                res.getWriter().flush();
            } else if ("post".equals(action)) {
                String message = req.getParameterValues("message")[0];
                event.getBroadcaster().broadcast((Object)(BEGIN_SCRIPT_TAG + this.toJsonp(name, message) + END_SCRIPT_TAG));
                res.getWriter().write("success");
                res.getWriter().flush();
            } else {
                res.setStatus(422);
                res.getWriter().write("success");
                res.getWriter().flush();
            }
        }
        return event;
    }

    public AtmosphereEvent<HttpServletRequest, HttpServletResponse> onMessage(AtmosphereEvent<HttpServletRequest, HttpServletResponse> event) throws IOException {
        HttpServletRequest req = (HttpServletRequest)event.getRequest();
        HttpServletResponse res = (HttpServletResponse)event.getResponse();
        if (event.isCancelled()) {
            event.getBroadcaster().broadcast((Object)(BEGIN_SCRIPT_TAG + this.toJsonp(req.getSession().getAttribute("name").toString(), " has left") + END_SCRIPT_TAG));
        } else if (event.isResuming() || event.isResumedOnTimeout()) {
            String script = "<script type='text/javascript'>\nwindow.parent.app.listen();\n</script>\n";
            res.getWriter().write(script);
            res.getWriter().flush();
        } else {
            res.getWriter().write(event.getMessage().toString());
            res.getWriter().flush();
        }
        return event;
    }

    private String escape(String orig) {
        StringBuffer buffer = new StringBuffer(orig.length());
        block13: for (int i = 0; i < orig.length(); ++i) {
            char c = orig.charAt(i);
            switch (c) {
                case '\b': {
                    buffer.append("\\b");
                    continue block13;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block13;
                }
                case '\n': {
                    buffer.append("<br />");
                    continue block13;
                }
                case '\r': {
                    continue block13;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block13;
                }
                case '\'': {
                    buffer.append("\\'");
                    continue block13;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block13;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block13;
                }
                case '<': {
                    buffer.append("&lt;");
                    continue block13;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block13;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block13;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    private String toJsonp(String name, String message) {
        return "window.parent.app.update({ name: \"" + this.escape(name) + "\", message: \"" + this.escape(message) + "\" });\n";
    }
}

