/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.chat;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.plugin.jgroups.JGroupsFilter;
import org.atmosphere.util.XSSHtmlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatAtmosphereHandler
implements AtmosphereHandler<HttpServletRequest, HttpServletResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ChatAtmosphereHandler.class);
    private static final String BEGIN_SCRIPT_TAG = "<script type='text/javascript'>\n";
    private static final String END_SCRIPT_TAG = "</script>\n";
    private static final long serialVersionUID = -2919167206889576860L;
    private static final String CLUSTER = "org.atmosphere.useCluster";
    private AtomicBoolean filterAdded = new AtomicBoolean(false);

    public void onRequest(AtmosphereResource<HttpServletRequest, HttpServletResponse> event) throws IOException {
        HttpServletRequest req = (HttpServletRequest)event.getRequest();
        HttpServletResponse res = (HttpServletResponse)event.getResponse();
        res.setContentType("text/html;charset=ISO-8859-1");
        if (req.getMethod().equalsIgnoreCase("GET")) {
            event.suspend();
            Broadcaster bc = event.getBroadcaster();
            String clusterType = event.getAtmosphereConfig().getInitParameter(CLUSTER);
            if (!this.filterAdded.getAndSet(true) && clusterType != null && clusterType.equals("jgroups")) {
                event.getAtmosphereConfig().getServletContext().log("JGroupsFilter enabled");
                bc.getBroadcasterConfig().addFilter((BroadcastFilter)new JGroupsFilter(bc));
            }
            bc.getBroadcasterConfig().addFilter((BroadcastFilter)new XSSHtmlFilter());
            Future f = bc.broadcast((Object)(event.getAtmosphereConfig().getWebServerName() + "**has suspended a connection from " + req.getRemoteAddr()));
            try {
                f.get();
            }
            catch (InterruptedException ex) {
                logger.error("", (Throwable)ex);
            }
            catch (ExecutionException ex) {
                logger.error("", (Throwable)ex);
            }
            bc.scheduleFixedBroadcast((Object)(req.getRemoteAddr() + "**is still listening"), 30L, TimeUnit.SECONDS);
            bc.delayBroadcast((Object)"Delayed Chat message");
        } else if (req.getMethod().equalsIgnoreCase("POST")) {
            String action = req.getParameterValues("action")[0];
            String name = req.getParameterValues("name")[0];
            if ("login".equals(action)) {
                req.getSession().setAttribute("name", (Object)name);
                event.getBroadcaster().broadcast((Object)("System Message from " + event.getAtmosphereConfig().getWebServerName() + "**" + name + " has joined."));
            } else if ("post".equals(action)) {
                String message = req.getParameterValues("message")[0];
                event.getBroadcaster().broadcast((Object)(name + "**" + message));
            } else {
                res.setStatus(422);
            }
            res.getWriter().write("success");
            res.getWriter().flush();
        }
    }

    public void onStateChange(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) throws IOException {
        String e;
        HttpServletRequest req = (HttpServletRequest)event.getResource().getRequest();
        HttpServletResponse res = (HttpServletResponse)event.getResource().getResponse();
        if (event.getMessage() == null) {
            return;
        }
        String name = e = event.getMessage().toString();
        String message = "";
        if (e.indexOf("**") > 0) {
            name = e.substring(0, e.indexOf("**"));
            message = e.substring(e.indexOf("**") + 2);
        }
        String msg = BEGIN_SCRIPT_TAG + this.toJsonp(name, message) + END_SCRIPT_TAG;
        if (event.isCancelled()) {
            event.getResource().getBroadcaster().broadcast((Object)(req.getSession().getAttribute("name") + " has left"));
        } else if (event.isResuming() || event.isResumedOnTimeout()) {
            String script = "<script>window.parent.app.listen();\n</script>";
            res.getWriter().write(script);
        } else {
            res.getWriter().write(msg);
        }
        res.getWriter().flush();
    }

    private String toJsonp(String name, String message) {
        return "window.parent.app.update({ name: \"" + name + "\", message: \"" + message + "\" });\n";
    }

    public void destroy() {
    }
}

