/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.chat;

import java.io.IOException;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.Ready;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.samples.chat.JacksonDecoder;
import org.atmosphere.samples.chat.JacksonEncoder;
import org.atmosphere.samples.chat.Message;
import org.atmosphere.samples.chat.custom.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Config
@ManagedService(path="/chat")
public class Chat {
    private final Logger logger = LoggerFactory.getLogger(Chat.class);

    @Ready
    public void onReady(AtmosphereResource r) {
        this.logger.info("Browser {} connected.", (Object)r.uuid());
    }

    @Disconnect
    public void onDisconnect(AtmosphereResourceEvent event) {
        if (event.isCancelled()) {
            this.logger.info("Browser {} unexpectedly disconnected", (Object)event.getResource().uuid());
        } else if (event.isClosedByClient()) {
            this.logger.info("Browser {} closed the connection", (Object)event.getResource().uuid());
        }
    }

    @org.atmosphere.config.service.Message(encoders={JacksonEncoder.class}, decoders={JacksonDecoder.class})
    public Message onMessage(Message message) throws IOException {
        this.logger.info("{} just send {}", (Object)message.getAuthor(), (Object)message.getMessage());
        return message;
    }
}

