/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.chat;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.Heartbeat;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.Ready;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.samples.chat.JacksonDecoder;
import org.atmosphere.samples.chat.JacksonEncoder;
import org.atmosphere.samples.chat.Message;
import org.atmosphere.samples.chat.custom.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Config
@ManagedService(path="/chat", atmosphereConfig={"org.atmosphere.cpr.CometSupport.maxInactiveActivity=120000"})
public class Chat {
    private final Logger logger = LoggerFactory.getLogger(Chat.class);
    @Inject
    private BroadcasterFactory factory;
    @Inject
    @Named(value="/chat")
    private Broadcaster broadcaster;
    @Inject
    private AtmosphereResource r;
    @Inject
    private AtmosphereResourceEvent event;

    @Heartbeat
    public void onHeartbeat(AtmosphereResourceEvent event) {
        this.logger.trace("Heartbeat send by {}", (Object)event.getResource());
    }

    @Ready
    public void onReady() {
        this.logger.info("Browser {} connected", (Object)this.r.uuid());
        this.logger.info("BroadcasterFactory used {}", (Object)this.factory.getClass().getName());
        this.logger.info("Broadcaster injected {}", (Object)this.broadcaster.getID());
    }

    @Disconnect
    public void onDisconnect() {
        if (this.event.isCancelled()) {
            this.logger.info("Browser {} unexpectedly disconnected", (Object)this.event.getResource().uuid());
        } else if (this.event.isClosedByClient()) {
            this.logger.info("Browser {} closed the connection", (Object)this.event.getResource().uuid());
        }
    }

    @org.atmosphere.config.service.Message(encoders={JacksonEncoder.class}, decoders={JacksonDecoder.class})
    public Message onMessage(Message message) throws IOException {
        this.logger.info("{} just sent {}", (Object)message.getAuthor(), (Object)message.getMessage());
        return message;
    }
}

