/*
 * Decompiled with CFR 0.152.
 */
package org.webtide.demo.auction;

import java.util.Map;
import org.eclipse.jetty.util.ajax.JSON;
import org.webtide.demo.auction.Category;
import org.webtide.demo.auction.Utils;

public class Item
implements Cloneable,
JSON.Convertible {
    private static final long serialVersionUID = -3390759314943527594L;
    private Integer id;
    private String itemName;
    private Category category;
    private String description;
    private Double initialPrice;

    public Item() {
    }

    public Item(Integer id, String itemName, Category category, String description, Double initialPrice) {
        this.setId(id);
        this.setItemName(itemName);
        this.setCategory(category);
        this.setDescription(description);
        this.setInitialPrice(initialPrice);
    }

    public String getFormattedAmount() {
        return Utils.formatCurrency((double)this.initialPrice);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer aId) {
        this.id = aId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
    }

    public Double getInitialPrice() {
        return this.initialPrice;
    }

    public void setInitialPrice(Double aInitialPrice) {
        this.initialPrice = aInitialPrice;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String aItemName) {
        this.itemName = aItemName;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category aCategory) {
        this.category = aCategory;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Item)) {
            return false;
        }
        return ((Item)obj).getId().equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public Item clone() {
        try {
            return (Item)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void fromJSON(Map object) {
    }

    public void toJSON(JSON.Output out) {
        out.add("itemId", (Object)this.id);
        out.add("name", (Object)this.itemName);
        out.add("description", (Object)this.description);
        out.add("categoryId", (Object)this.category.getId());
    }

    public String toString() {
        return JSON.toString((Object)this);
    }
}

