/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.counter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereEvent;
import org.atmosphere.cpr.AtmosphereHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterLongPollingAtmosphereHandler
implements AtmosphereHandler<HttpServletRequest, HttpServletResponse> {
    private final AtomicInteger counter = new AtomicInteger();

    public AtmosphereEvent onEvent(AtmosphereEvent<HttpServletRequest, HttpServletResponse> event) throws IOException {
        if (((HttpServletRequest)event.getRequest()).getMethod().equals("GET")) {
            event.suspend();
        } else {
            this.counter.incrementAndGet();
            event.getBroadcaster().broadcast((Object)"");
            PrintWriter writer = ((HttpServletResponse)event.getResponse()).getWriter();
            writer.write("success");
            writer.flush();
        }
        return event;
    }

    public AtmosphereEvent onMessage(AtmosphereEvent<HttpServletRequest, HttpServletResponse> event) throws IOException {
        int count = this.counter.get();
        if (event.isCancelled()) {
            return event;
        }
        if (!event.isResumedOnTimeout()) {
            ((HttpServletResponse)event.getResponse()).addHeader("X-JSON", "{\"counter\":" + count + " }");
            PrintWriter writer = ((HttpServletResponse)event.getResponse()).getWriter();
            writer.write("success");
            writer.flush();
            event.resume();
        } else {
            ((HttpServletResponse)event.getResponse()).addHeader("X-JSON", "{\"counter\":" + count + " }");
            PrintWriter writer = ((HttpServletResponse)event.getResponse()).getWriter();
            writer.write("success");
            writer.flush();
        }
        return event;
    }
}

