/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.counter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterLongPollingAtmosphereHandler
implements AtmosphereHandler<HttpServletRequest, HttpServletResponse> {
    private final AtomicInteger counter = new AtomicInteger();

    public void onRequest(AtmosphereResource<HttpServletRequest, HttpServletResponse> event) throws IOException {
        if (((HttpServletRequest)event.getRequest()).getMethod().equals("GET")) {
            event.suspend();
        } else {
            this.counter.incrementAndGet();
            event.getBroadcaster().broadcast((Object)"");
            PrintWriter writer = ((HttpServletResponse)event.getResponse()).getWriter();
            writer.write("success");
            writer.flush();
        }
    }

    public void onStateChange(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) throws IOException {
        int count = this.counter.get();
        if (event.isCancelled()) {
            return;
        }
        if (!event.isResumedOnTimeout()) {
            ((HttpServletResponse)event.getResource().getResponse()).addHeader("X-JSON", "{\"counter\":" + count + " }");
            PrintWriter writer = ((HttpServletResponse)event.getResource().getResponse()).getWriter();
            writer.write("success");
            writer.flush();
            event.getResource().resume();
        } else {
            ((HttpServletResponse)event.getResource().getResponse()).addHeader("X-JSON", "{\"counter\":" + count + " }");
            PrintWriter writer = ((HttpServletResponse)event.getResource().getResponse()).getWriter();
            writer.write("success");
            writer.flush();
        }
    }
}

