/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.counter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterLongPollingAtmosphereHandler
implements AtmosphereHandler<HttpServletRequest, HttpServletResponse> {
    private AtomicInteger currentCount = new AtomicInteger(0);

    public void onRequest(AtmosphereResource<HttpServletRequest, HttpServletResponse> resource) throws IOException {
        HttpServletRequest req = (HttpServletRequest)resource.getRequest();
        if (req.getMethod().equals("GET")) {
            resource.suspend(-1L, false);
        } else {
            if (req.getParameter("stop").equalsIgnoreCase("true")) {
                resource.getBroadcaster().broadcast((Object)"");
            } else if (req.getParameter("current_count") != null) {
                Integer i = Integer.valueOf(req.getParameter("current_count"));
                if (i > this.currentCount.get()) {
                    this.currentCount.set(i);
                }
                resource.getBroadcaster().broadcast((Object)(i > this.currentCount.get() ? i.intValue() : this.currentCount.get()));
            }
            PrintWriter writer = ((HttpServletResponse)resource.getResponse()).getWriter();
            writer.write("success");
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStateChange(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) throws IOException {
        if (event.isCancelled()) {
            return;
        }
        int count = 0;
        if (event.getMessage() instanceof Integer) {
            count = (Integer)event.getMessage();
        }
        try {
            ((HttpServletResponse)event.getResource().getResponse()).addHeader("X-JSON", "{\"counter\":" + count + " }");
            PrintWriter writer = ((HttpServletResponse)event.getResource().getResponse()).getWriter();
            writer.write("success");
            writer.flush();
        }
        finally {
            if (!event.isResumedOnTimeout()) {
                event.getResource().resume();
            }
        }
    }
}

