/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.di.guice;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.atmosphere.annotation.Broadcast;
import org.atmosphere.annotation.Suspend;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.jersey.Broadcastable;
import org.atmosphere.jersey.JerseyBroadcaster;
import org.atmosphere.samples.di.guice.EventsLogger;
import org.atmosphere.samples.di.guice.Service;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/topic")
@Singleton
@Produces(value={"application/json"})
public class MessageResource {
    private static final Logger logger = LoggerFactory.getLogger(MessageResource.class);
    @Inject
    Service service;

    @GET
    @Path(value="{name}")
    @Suspend(outputComments=true, resumeOnBroadcast=false, listeners={EventsLogger.class})
    public Broadcastable listen(@PathParam(value="name") String topic) throws JSONException {
        Broadcaster broadcaster = BroadcasterFactory.getDefault().lookup(JerseyBroadcaster.class, (Object)topic, true);
        logger.info("thread: {} LISTENING to '{}'", (Object)Thread.currentThread().getName(), (Object)broadcaster.getID());
        if (this.service == null) {
            throw new AssertionError();
        }
        return new Broadcastable((Object)new JSONObject().put("from", (Object)"system").put("msg", (Object)"Connected !"), broadcaster);
    }

    @POST
    @Path(value="{name}")
    @Broadcast
    public Broadcastable publish(@PathParam(value="name") String topic, @FormParam(value="from") String from, @FormParam(value="msg") String message) throws JSONException {
        Broadcaster broadcaster = BroadcasterFactory.getDefault().lookup(JerseyBroadcaster.class, (Object)topic, true);
        logger.info("thread: {} PUBLISH to '{}' from {}: {}", new Object[]{Thread.currentThread().getName(), broadcaster.getID(), from, message});
        if (this.service == null) {
            throw new AssertionError();
        }
        return new Broadcastable((Object)new JSONObject().put("from", (Object)from).put("msg", (Object)message), (Object)"", broadcaster);
    }
}

