/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.di.guice;

import com.google.inject.Inject;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.samples.di.guice.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsLogger
implements AtmosphereResourceEventListener {
    private static final Logger logger = LoggerFactory.getLogger(EventsLogger.class);
    @Inject
    private Service service;

    public void onPreSuspend(AtmosphereResourceEvent event) {
    }

    public void onSuspend(AtmosphereResourceEvent event) {
        if (this.service == null) {
            throw new AssertionError();
        }
        logger.info("[{}] onSuspend: {}:{}", new Object[]{Thread.currentThread().getName(), event.getResource().getRequest().getRemoteAddr(), event.getResource().getRequest().getRemotePort()});
    }

    public void onResume(AtmosphereResourceEvent event) {
        if (this.service == null) {
            throw new AssertionError();
        }
        logger.info("[{}] onResume: {}:{}", new Object[]{Thread.currentThread().getName(), event.getResource().getRequest().getRemoteAddr(), event.getResource().getRequest().getRemotePort()});
    }

    public void onDisconnect(AtmosphereResourceEvent event) {
        if (this.service == null) {
            throw new AssertionError();
        }
        logger.info("[{}] onDisconnect: {}:{}", new Object[]{Thread.currentThread().getName(), event.getResource().getRequest().getRemoteAddr(), event.getResource().getRequest().getRemotePort()});
    }

    public void onBroadcast(AtmosphereResourceEvent event) {
        if (this.service == null) {
            throw new AssertionError();
        }
        logger.info("[{}] onBroadcast: {}:{}", new Object[]{Thread.currentThread().getName(), event.getResource().getRequest().getRemoteAddr(), event.getResource().getRequest().getRemotePort()});
    }

    public void onThrowable(AtmosphereResourceEvent event) {
        if (this.service == null) {
            throw new AssertionError();
        }
        logger.info("[{}] onThrowable: " + event.getResource().getRequest().getRemoteAddr() + ":" + event.getResource().getRequest().getRemotePort(), event.throwable());
    }
}

