/*
 * Decompiled with CFR 0.152.
 */
package org.jersey.devoxx.samples.ee6.atmosphere;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.Semaphore;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import org.atmosphere.annotation.Suspend;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.jersey.Broadcastable;
import org.atmosphere.jersey.JerseyBroadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="timer")
@Stateless
public class TimerResource {
    private static final Logger logger = LoggerFactory.getLogger(TimerResource.class);
    @Resource
    private TimerService ts;
    @Context
    private BroadcasterFactory bf;
    private Semaphore started = new Semaphore(1);
    private Semaphore stopped = new Semaphore(1);
    private Broadcaster tb;
    private Timer t;

    @PostConstruct
    private void postConstruct() {
        this.stopped.tryAcquire();
    }

    private Broadcaster getTimerBroadcaster() {
        return this.bf.lookup(JerseyBroadcaster.class, (Object)"timer", true);
    }

    @Suspend
    @GET
    public Broadcastable get() {
        return new Broadcastable(this.getTimerBroadcaster());
    }

    @Path(value="start")
    @POST
    public void start() {
        if (this.started.tryAcquire()) {
            this.tb = this.getTimerBroadcaster();
            this.t = this.ts.createIntervalTimer(1000L, 1000L, new TimerConfig((Serializable)((Object)"timer"), false));
            this.stopped.release();
        }
    }

    @Timeout
    public void timeout(Timer timer) {
        logger.info("{}: {}", (Object)this.getClass().getName(), (Object)new Date());
        this.tb.broadcast((Object)(new Date().toString() + "\n"));
    }

    @Path(value="stop")
    @POST
    public void stop() {
        if (this.stopped.tryAcquire()) {
            this.t.cancel();
            this.tb = null;
            this.t = null;
            this.started.release();
        }
    }

    @Path(value="hardstop")
    @POST
    public void hardstop() {
        this.stop();
        this.getTimerBroadcaster().resumeAll();
    }
}

