/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.guice;

import com.google.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.atmosphere.annotation.Broadcast;
import org.atmosphere.annotation.Suspend;
import org.atmosphere.samples.guice.EventListener;
import org.atmosphere.samples.guice.InjectedService;
import org.atmosphere.samples.guice.Message;
import org.atmosphere.samples.guice.Response;

@Path(value="/")
@Produces(value={"application/json"})
public class ResourceChat {
    private final InjectedService injectedService;

    @Inject
    ResourceChat(InjectedService injectedService) {
        this.injectedService = injectedService;
    }

    @Suspend(listeners={EventListener.class})
    @GET
    public String suspend() {
        if (this.injectedService == null) {
            throw new WebApplicationException(500);
        }
        return "";
    }

    @Broadcast(writeEntity=false)
    @POST
    public Response broadcast(Message message) {
        if (this.injectedService == null) {
            throw new WebApplicationException(500);
        }
        return new Response(message.author, message.message);
    }
}

