/*
 * Decompiled with CFR 0.152.
 */
package cometedgwt.auction.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import cometedgwt.auction.client.App;
import cometedgwt.auction.client.StreamingService;
import cometedgwt.auction.client.StreamingServiceGWTClientImpl;
import cometedgwt.auction.entity.AuctionItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class App
implements EntryPoint {
    public static final String TOPIC = "bids";
    private StreamingService streamingService;
    private Map mapOfItemPrices = new HashMap();
    private Map mapOfNumberOfBids = new HashMap();

    public void onModuleLoad() {
        List itens = this.getAuctionItens();
        Grid table = new Grid(itens.size() + 1, 6);
        table.setStylePrimaryName("corpo");
        table.setText(0, 0, "Item Name");
        table.setText(0, 1, "# of bids");
        table.setText(0, 2, "Price");
        table.setText(0, 3, "My bid");
        for (int i = 0; i < itens.size(); ++i) {
            AuctionItem item = (AuctionItem)itens.get(i);
            int itemId = item.getId();
            Label labelNumberOfBids = new Label(String.valueOf(item.getNumberOfBids()));
            Label labelPrice = new Label("$ " + String.valueOf(item.getPrice()));
            TextBox txtBoxMyBid = new TextBox();
            Button bidButton = new Button("Bid!");
            Label labelMessage = new Label("");
            bidButton.setStylePrimaryName("principal");
            this.mapOfItemPrices.put(new Integer(itemId), labelPrice);
            this.mapOfNumberOfBids.put(new Integer(itemId), labelNumberOfBids);
            txtBoxMyBid.addKeyboardListener((KeyboardListener)new /* Unavailable Anonymous Inner Class!! */);
            bidButton.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            table.setText(i + 1, 0, item.getName());
            table.setWidget(i + 1, 1, (Widget)labelNumberOfBids);
            table.setWidget(i + 1, 2, (Widget)labelPrice);
            table.setWidget(i + 1, 3, (Widget)txtBoxMyBid);
            table.setWidget(i + 1, 4, (Widget)bidButton);
            table.setWidget(i + 1, 5, (Widget)labelMessage);
        }
        RootPanel.get((String)"slot1").add((Widget)table);
        this.streamingService = StreamingServiceGWTClientImpl.getInstance();
        this.streamingService.subScribeToEvent(TOPIC, (AsyncCallback)new BidCallback(this, null));
    }

    private List getAuctionItens() {
        AuctionItem item1 = new AuctionItem(0, "???? Nokia N80", 100.0);
        AuctionItem item2 = new AuctionItem(1, "Laptop Apple PowerBook G4 17''", 1050.0);
        AuctionItem item3 = new AuctionItem(2, "Canon Rebel XT", 800.0);
        ArrayList<AuctionItem> itens = new ArrayList<AuctionItem>();
        itens.add(item1);
        itens.add(item2);
        itens.add(item3);
        return itens;
    }

    private void sendNewBid(AuctionItem item, TextBox myBid, Label message) {
        int itemId = item.getId();
        double lastBid = item.getPrice();
        String newBid = myBid.getText();
        double newBidValue = 0.0;
        try {
            newBidValue = Double.parseDouble(newBid);
        }
        catch (NumberFormatException e) {
            message.setText("Not a valid bid");
            return;
        }
        if (newBidValue < lastBid) {
            message.setText("Not a valid bid");
            return;
        }
        message.setText("");
        item.setPrice(newBidValue);
        int numberOfBids = item.getNumberOfBids();
        JSONArray array = new JSONArray();
        array.set(0, (JSONValue)new JSONNumber((double)itemId));
        array.set(1, (JSONValue)new JSONNumber(newBidValue));
        array.set(2, (JSONValue)new JSONNumber((double)numberOfBids));
        JSONObject container = new JSONObject();
        container.put("value", (JSONValue)array);
        this.streamingService.sendMessage(TOPIC, (JSONValue)container);
        myBid.setText("");
        myBid.setFocus(true);
    }

    static /* synthetic */ Map access$000(App x0) {
        return x0.mapOfItemPrices;
    }

    static /* synthetic */ Map access$100(App x0) {
        return x0.mapOfNumberOfBids;
    }

    static /* synthetic */ void access$200(App x0, AuctionItem x1, TextBox x2, Label x3) {
        x0.sendNewBid(x1, x2, x3);
    }
}

