/*
 * Decompiled with CFR 0.152.
 */
package cometedgwt.auction.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.json.client.JSONException;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextArea;
import cometedgwt.auction.client.StreamingService;
import cometedgwt.auction.client.StreamingServiceGWTClientImpl;
import cometedgwt.auction.client.StreamingServiceInternalGWT;
import cometedgwt.auction.client.StreamingServiceInternalGWTAsync;
import java.util.HashMap;
import java.util.Map;

public class StreamingServiceGWTClientImpl
implements StreamingService {
    private int watchDogTimerTime = 100000;
    Map callbacks = new HashMap();
    private boolean keepAlive = false;
    private final String streamingServicePath = GWT.getModuleBaseURL() + "streamingServlet";
    private static StreamingService instance = null;
    private final StreamingServiceInternalGWTAsync service = (StreamingServiceInternalGWTAsync)GWT.create(StreamingServiceInternalGWT.class);
    private final Map waitingSubscriber = new HashMap();
    private static final AsyncCallback voidCallback = new /* Unavailable Anonymous Inner Class!! */;
    private final AsyncCallback restartStreamingCallback = new /* Unavailable Anonymous Inner Class!! */;
    private final AsyncCallback internalKeepAliveCallback = new /* Unavailable Anonymous Inner Class!! */;
    private final TextArea textArea = new TextArea();

    public static StreamingService getInstance() {
        if (instance == null) {
            instance = new StreamingServiceGWTClientImpl();
        }
        return instance;
    }

    private StreamingServiceGWTClientImpl() {
        this.callbacks.put("keepAliveInternal", this.internalKeepAliveCallback);
        this.callbacks.put("restartStreamingInternal", this.restartStreamingCallback);
        ((ServiceDefTarget)this.service).setServiceEntryPoint(GWT.getModuleBaseURL() + "streamingService");
        this.setUpNativeCode((StreamingService)this);
        this.restartStreamingFromIFrame();
        this.createWatchDogTimer();
    }

    private void callback(String topicName, String data) {
        this.keepAlive = true;
        this.alert("received callback for (" + topicName + "," + data + ")");
        if (this.callbacks.containsKey(topicName)) {
            AsyncCallback callback = (AsyncCallback)this.callbacks.get(topicName);
            try {
                String dataToSend = data;
                if (data.startsWith("$JSONSTART$") && data.endsWith("$JSONEND$")) {
                    dataToSend = JSONParser.parse((String)data.substring("$JSONSTART$".length(), data.length() - "$JSONEND$".length()));
                }
                callback.onSuccess((Object)dataToSend);
            }
            catch (JSONException e) {
                callback.onFailure((Throwable)e);
            }
        } else {
            this.alert("received event for a not subscribed topic: '" + topicName + "'");
            this.alert("current topics are: " + this.callbacks.keySet());
        }
    }

    private native void setUpNativeCode(StreamingService var1);

    private void createWatchDogTimer() {
        4 t = new /* Unavailable Anonymous Inner Class!! */;
        t.scheduleRepeating(this.watchDogTimerTime);
    }

    private void restartStreamingFromIFrame() {
        Element iframe = DOM.getElementById((String)"__gwt_streamingFrame");
        if (iframe != null) {
            DOM.removeChild((Element)RootPanel.getBodyElement(), (Element)iframe);
        }
        iframe = DOM.createIFrame();
        DOM.setAttribute((Element)iframe, (String)"id", (String)"__gwt_streamingFrame");
        DOM.setStyleAttribute((Element)iframe, (String)"width", (String)"0");
        DOM.setStyleAttribute((Element)iframe, (String)"height", (String)"0");
        DOM.setStyleAttribute((Element)iframe, (String)"border", (String)"0");
        DOM.appendChild((Element)RootPanel.getBodyElement(), (Element)iframe);
        DOM.setAttribute((Element)iframe, (String)"src", (String)this.streamingServicePath);
    }

    public void sendMessage(String topicName, String data) {
        this.service.sendMessage(topicName, data, voidCallback);
    }

    public void sendMessage(String topicName, JSONValue object) {
        this.sendMessage(topicName, "$JSONSTART$" + object.toString() + "$JSONEND$");
    }

    public void subScribeToEvent(String topicName, AsyncCallback callback) {
        if (this.keepAlive) {
            this.alert("Streaming is alive, subscribing to '" + topicName + "' with callback " + callback);
            this.service.subscribeToTopic(topicName, voidCallback);
            this.callbacks.put(topicName, callback);
            this.alert(this.callbacks.toString());
        } else {
            this.alert("Streaming is not alive, subscriber '" + topicName + "' is cached with callback " + callback + " until online");
            this.waitingSubscriber.put(topicName, callback);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void alert(String message) {
        if (GWT.isScript()) {
            RootPanel debugDiv = RootPanel.get((String)"debug");
            if (debugDiv == null) return;
        }
        GWT.log((String)message, null);
    }

    static /* synthetic */ void access$000(StreamingServiceGWTClientImpl x0) {
        x0.restartStreamingFromIFrame();
    }

    static /* synthetic */ void access$100(StreamingServiceGWTClientImpl x0, String x1, String x2) {
        x0.callback(x1, x2);
    }

    static /* synthetic */ void access$200(StreamingServiceGWTClientImpl x0, String x1) {
        x0.alert(x1);
    }

    static /* synthetic */ boolean access$302(StreamingServiceGWTClientImpl x0, boolean x1) {
        x0.keepAlive = x1;
        return x0.keepAlive;
    }

    static /* synthetic */ int access$402(StreamingServiceGWTClientImpl x0, int x1) {
        x0.watchDogTimerTime = x1;
        return x0.watchDogTimerTime;
    }

    static /* synthetic */ Map access$500(StreamingServiceGWTClientImpl x0) {
        return x0.waitingSubscriber;
    }

    static /* synthetic */ boolean access$300(StreamingServiceGWTClientImpl x0) {
        return x0.keepAlive;
    }
}

