/*
 * Decompiled with CFR 0.152.
 */
package org.gwtcomet.server;

import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gwtcomet.server.StreamingServiceBusiness;

public class StreamingServiceBusiness {
    private static final long serialVersionUID = 1L;
    private final ConcurrentMap<String, ConcurrentHashMap<String, Boolean>> queues = new ConcurrentHashMap();
    private final Observable observable = new EventObservable();

    public void subscribeToTopic(String topicName, String clientName) {
        if (!this.queues.containsKey(topicName)) {
            this.queues.put(topicName, new ConcurrentHashMap());
        }
        ((ConcurrentHashMap)this.queues.get(topicName)).putIfAbsent(clientName, Boolean.TRUE);
    }

    public void unsubscribeFromTopic(String topicName, String clientName) {
        if (this.queues.containsKey(topicName) && ((ConcurrentHashMap)this.queues.get(topicName)).containsKey(clientName)) {
            ((ConcurrentHashMap)this.queues.get(topicName)).remove(clientName);
        }
    }

    public boolean isClientSubscribedToQueue(String topicName, String clientName) {
        return this.queues.containsKey(topicName) && ((ConcurrentHashMap)this.queues.get(topicName)).containsKey(clientName);
    }

    public void addObserver(Observer observer) {
        this.observable.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.observable.deleteObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEvents(long keepAliveTimeout) {
        try {
            Observable observable = this.observable;
            synchronized (observable) {
                this.observable.wait(keepAliveTimeout);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String queueName, String message) {
        Observable observable = this.observable;
        synchronized (observable) {
            this.observable.notifyObservers(new Event(queueName, message));
        }
    }
}

