/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.server;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.gwt.server.AtmosphereGwtHandler;
import org.atmosphere.gwt.server.GwtAtmosphereResource;

public class ChatHandler
extends AtmosphereGwtHandler {
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        Logger.getLogger("").setLevel(Level.INFO);
        Logger.getLogger("org.atmosphere.gwt").setLevel(Level.ALL);
        Logger.getLogger("org.atmosphere.samples").setLevel(Level.ALL);
        Logger.getLogger("").getHandlers()[0].setLevel(Level.ALL);
        this.logger.trace("Updated logging levels");
    }

    public int doComet(GwtAtmosphereResource resource) throws ServletException, IOException {
        String room = resource.getRequest().getPathInfo();
        Broadcaster broadcaster = BroadcasterFactory.getDefault().lookup((Object)room, true);
        resource.getAtmosphereResource().setBroadcaster(broadcaster);
        return 300000;
    }

    public void cometTerminated(GwtAtmosphereResource cometResponse, boolean serverInitiated) {
        super.cometTerminated(cometResponse, serverInitiated);
        this.logger.info("Comet disconnected");
    }

    public void doPost(HttpServletRequest postRequest, HttpServletResponse postResponse, List<?> messages, GwtAtmosphereResource cometResource) {
        this.broadcast(messages, cometResource);
    }
}

