/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.logging.client.HasWidgetsLogHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.atmosphere.gwt.client.AtmosphereClient;
import org.atmosphere.gwt.client.AtmosphereGWTSerializer;
import org.atmosphere.samples.client.Event;
import org.atmosphere.samples.client.EventSerializer;
import org.atmosphere.samples.client.GWTDemo;

public class GWTDemo
implements EntryPoint {
    static final Logger logger = Logger.getLogger(GWTDemo.class.getName());
    static final String LABEL_ENTER_ROOM = "Type your name to enter the room";
    static final String LABEL_TYPE_MESSAGE = "Type a message to send to the room";
    static final String MESSAGE_JOINED_ROOM = "&lt;joined the room&gt;";
    static final String MESSAGE_LEFT_ROOM = "&lt;left the room&gt;";
    static final String MESSAGE_ROOM_CONNECTED = "[connected to room]";
    static final String MESSAGE_ROOM_DISCONNECTED = "[disconnected from room]";
    static final String MESSAGE_ROOM_ERROR = "Error: ";
    static final String COLOR_SYSTEM_MESSAGE = "grey";
    static final String COLOR_MESSAGE_SELF = "green";
    static final String COLOR_MESSAGE_OTHERS = "red";
    int count = 0;
    AtmosphereClient client;
    MyCometListener cometListener = new MyCometListener(this, null);
    AtmosphereGWTSerializer serializer = (AtmosphereGWTSerializer)GWT.create(EventSerializer.class);
    String author;
    Label label;
    TextBox input;
    Element chat;
    String room = "room1";

    public void onModuleLoad() {
        ListBox roomSelect = new ListBox();
        roomSelect.addItem("Room 1", "room1");
        roomSelect.addItem("Room 2", "room2");
        roomSelect.addItem("Room 3", "room3");
        roomSelect.addItem("Room 4", "room4");
        roomSelect.setSelectedIndex(0);
        roomSelect.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        RootPanel.get((String)"room").add((Widget)roomSelect);
        this.chat = Document.get().getElementById("chat");
        this.label = new Label(LABEL_ENTER_ROOM);
        RootPanel.get((String)"label").add((Widget)this.label);
        this.input = new TextBox();
        this.input.addKeyDownHandler((KeyDownHandler)new /* Unavailable Anonymous Inner Class!! */);
        RootPanel.get((String)"input").add((Widget)this.input);
        Button send = new Button("Send");
        send.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        RootPanel.get((String)"send").add((Widget)send);
        4 logPanel = new /* Unavailable Anonymous Inner Class!! */;
        RootPanel.get((String)"logger").add((Widget)logPanel);
        Logger.getLogger("").addHandler((Handler)new HasWidgetsLogHandler((HasWidgets)logPanel));
        this.changeRoom(this.room);
    }

    void sendMessage(String message) {
        if (this.author == null) {
            this.author = message;
            this.client.broadcast((Object)new Event(this.author, MESSAGE_JOINED_ROOM));
            this.label.setText(LABEL_TYPE_MESSAGE);
        } else {
            this.client.broadcast((Object)new Event(this.author, message));
        }
    }

    String getUrl() {
        return GWT.getModuleBaseURL() + "gwtComet/" + this.room;
    }

    void changeRoom(String newRoom) {
        if (this.client != null) {
            if (this.author != null) {
                this.client.broadcast((Object)new Event(this.author, MESSAGE_LEFT_ROOM));
            }
            this.client.stop();
            this.client = null;
        }
        this.author = null;
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    void clearChat() {
        this.chat.setInnerHTML("");
    }

    void addChatLine(String line, String color) {
        HTML newLine = new HTML(line);
        newLine.getElement().getStyle().setColor(color);
        this.chat.appendChild((Node)newLine.getElement());
        newLine.getElement().scrollIntoView();
    }
}

