/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.server;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.atmosphere.gwt.server.AtmosphereGwtHandler;
import org.atmosphere.gwt.server.GwtAtmosphereResource;

public class AtmosphereHandler
extends AtmosphereGwtHandler {
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        Logger.getLogger("").setLevel(Level.INFO);
        Logger.getLogger("gwtcomettest").setLevel(Level.ALL);
        Logger.getLogger("").getHandlers()[0].setLevel(Level.ALL);
        this.logger.trace("Updated logging levels");
    }

    public int doComet(GwtAtmosphereResource resource) throws ServletException, IOException {
        resource.getBroadcaster().setID("GWT_COMET");
        HttpSession session = ((HttpServletRequest)resource.getAtmosphereResource().getRequest()).getSession(false);
        if (session != null) {
            this.logger.debug("Got session with id: " + session.getId());
            this.logger.debug("Time attribute: " + session.getAttribute("time"));
        } else {
            this.logger.warn("No session");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Url: " + ((HttpServletRequest)resource.getAtmosphereResource().getRequest()).getRequestURL() + "?" + ((HttpServletRequest)resource.getAtmosphereResource().getRequest()).getQueryString());
        }
        return -1;
    }

    public void cometTerminated(GwtAtmosphereResource cometResponse, boolean serverInitiated) {
        super.cometTerminated(cometResponse, serverInitiated);
        this.logger.debug("Comet disconnected");
    }
}

