/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.server;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.atmosphere.gwt.server.AtmosphereGwtHandler;
import org.atmosphere.gwt.server.GwtAtmosphereResource;

public class AtmosphereHandler
extends AtmosphereGwtHandler {
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        Logger.getLogger("").setLevel(Level.INFO);
        Logger.getLogger("org.atmosphere.gwt").setLevel(Level.ALL);
        Logger.getLogger("org.atmosphere.samples").setLevel(Level.ALL);
        Logger.getLogger("").getHandlers()[0].setLevel(Level.ALL);
        this.logger.trace("Updated logging levels");
    }

    public int doComet(GwtAtmosphereResource resource) throws ServletException, IOException {
        resource.getBroadcaster().setID("GWT_COMET");
        HttpSession session = resource.getAtmosphereResource().getRequest().getSession(false);
        if (session != null) {
            this.logger.debug("Got session with id: " + session.getId());
            this.logger.debug("Time attribute: " + session.getAttribute("time"));
        } else {
            this.logger.warn("No session");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Url: " + resource.getAtmosphereResource().getRequest().getRequestURL() + "?" + resource.getAtmosphereResource().getRequest().getQueryString());
        }
        String agent = resource.getRequest().getHeader("user-agent");
        this.logger.info(agent);
        return -1;
    }

    public void cometTerminated(GwtAtmosphereResource cometResponse, boolean serverInitiated) {
        super.cometTerminated(cometResponse, serverInitiated);
        this.logger.info("Comet disconnected");
    }

    public void doPost(HttpServletRequest postRequest, HttpServletResponse postResponse, List<Serializable> messages, GwtAtmosphereResource cometResource) {
        HttpSession session = postRequest.getSession(false);
        if (session != null) {
            this.logger.info("Post has session with id: " + session.getId());
        } else {
            this.logger.info("Post has no session");
        }
        super.doPost(postRequest, postResponse, messages, cometResource);
    }
}

