/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.webrtc;

import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.jersey.SuspendResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/channels/{topic}")
@Produces(value={"text/html;charset=ISO-8859-1"})
public class Subscriber {
    private static final Logger logger = LoggerFactory.getLogger(Subscriber.class);

    @GET
    public SuspendResponse<String> subscribe(@PathParam(value="topic") Broadcaster topic) {
        return new SuspendResponse.SuspendResponseBuilder().broadcaster(topic).outputComments(true).build();
    }

    @POST
    public void publish(@FormParam(value="message") String message, @PathParam(value="topic") Broadcaster topic) {
        logger.info("Sending message {} to channel {}", new Object[]{message, topic.getID()});
        topic.broadcast((Object)message);
    }
}

