/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.chat;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import org.atmosphere.config.service.WebSocketHandlerService;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.util.SimpleBroadcaster;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListenerAdapter;
import org.atmosphere.websocket.WebSocketStreamingHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocketHandlerService(path="/chat", broadcaster=SimpleBroadcaster.class, atmosphereConfig={"org.atmosphere.websocket.WebSocketProtocol=org.atmosphere.websocket.protocol.StreamingHttpProtocol"})
public class WebSocketChat
extends WebSocketStreamingHandlerAdapter {
    private final Logger logger = LoggerFactory.getLogger(WebSocketChat.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public void onOpen(WebSocket webSocket) throws IOException {
        webSocket.resource().addEventListener((AtmosphereResourceEventListener)new WebSocketEventListenerAdapter(){

            public void onDisconnect(AtmosphereResourceEvent event) {
                if (event.isCancelled()) {
                    WebSocketChat.this.logger.info("Browser {} unexpectedly disconnected", (Object)event.getResource().uuid());
                } else if (event.isClosedByClient()) {
                    WebSocketChat.this.logger.info("Browser {} closed the connection", (Object)event.getResource().uuid());
                }
            }
        });
    }

    public void onTextStream(WebSocket webSocket, Reader reader) throws IOException {
        webSocket.broadcast((Object)this.mapper.writeValueAsString(this.mapper.readValue(new BufferedReader(reader).readLine(), Data.class)));
    }

    public static final class Data {
        private String message;
        private String author;
        private long time;

        public Data() {
            this("", "");
        }

        public Data(String author, String message) {
            this.author = author;
            this.message = message;
            this.time = new Date().getTime();
        }

        public String getMessage() {
            return this.message;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }
    }
}

