/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.chat;

import java.io.File;
import org.atmosphere.container.Jetty9AsyncSupportWithWebSocket;
import org.atmosphere.cpr.AtmosphereServlet;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        main.run();
    }

    private void run() throws Exception {
        Server server = new Server();
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
        http.setPort(8080);
        http.setIdleTimeout(30000L);
        server.setConnectors(new Connector[]{http});
        ResourceHandler resource_handler = new ResourceHandler();
        resource_handler.setDirectoriesListed(true);
        resource_handler.setWelcomeFiles(new String[]{"index.html"});
        resource_handler.setResourceBase(new File("target/webapp").getAbsolutePath());
        ServletHolder atmosphereServletHolder = new ServletHolder(AtmosphereServlet.class);
        atmosphereServletHolder.setInitParameter("org.atmosphere.cpr.packages", "org.atmosphere.samples.chat");
        atmosphereServletHolder.setInitParameter("org.atmosphere.websocket.messageContentType", "application/json");
        atmosphereServletHolder.setInitParameter("org.atmosphere.cpr.asyncSupport", Jetty9AsyncSupportWithWebSocket.class.getName());
        atmosphereServletHolder.setAsyncSupported(true);
        ServletContextHandler servletContextHandler = new ServletContextHandler(1);
        servletContextHandler.addServlet(atmosphereServletHolder, "/chat/*");
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{resource_handler, servletContextHandler});
        server.setHandler((Handler)handlers);
        server.setStopAtShutdown(true);
        server.start();
        server.join();
    }
}

