/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.chat;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.commons.jersey.JsonpFilter;
import org.atmosphere.commons.util.EventsLogger;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Meteor;
import org.atmosphere.util.XSSHtmlFilter;

public class MeteorChat
extends HttpServlet {
    private static final long serialVersionUID = -2919167206889576860L;
    private final List<BroadcastFilter> list = new LinkedList();

    public MeteorChat() {
        this.list.add(new XSSHtmlFilter());
        this.list.add(new JsonpFilter());
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Meteor m = Meteor.build((HttpServletRequest)req, (List)this.list, null);
        m.addListener((AtmosphereResourceEventListener)new EventsLogger());
        req.getSession().setAttribute("meteor", (Object)m);
        res.setContentType("text/html;charset=ISO-8859-1");
        m.suspend(-1L);
        m.broadcast((Object)(req.getServerName() + "__has suspended a connection from " + req.getRemoteAddr()));
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Meteor m = (Meteor)req.getSession().getAttribute("meteor");
        res.setCharacterEncoding("UTF-8");
        String action = req.getParameterValues("action")[0];
        String name = req.getParameterValues("name")[0];
        if ("login".equals(action)) {
            req.getSession().setAttribute("name", (Object)name);
            m.broadcast((Object)("System Message from " + req.getServerName() + "__" + name + " has joined."));
            res.getWriter().write("success");
            res.getWriter().flush();
        } else if ("post".equals(action)) {
            String message = req.getParameterValues("message")[0];
            m.broadcast((Object)(name + "__" + message));
            res.getWriter().write("success");
            res.getWriter().flush();
        } else {
            res.setStatus(422);
            res.getWriter().write("success");
            res.getWriter().flush();
        }
    }
}

