/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.pubsub;

import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.config.service.MeteorService;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.Meteor;
import org.atmosphere.websocket.WebSocketEventListenerAdapter;

@MeteorService
public class MeteorPubSub
extends HttpServlet {
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Meteor m = Meteor.build((HttpServletRequest)req);
        m.addListener((AtmosphereResourceEventListener)new WebSocketEventListenerAdapter());
        res.setContentType("text/html;charset=ISO-8859-1");
        Broadcaster b = this.lookupBroadcaster(req.getPathInfo());
        m.setBroadcaster(b);
        m.suspend(-1L);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Broadcaster b = this.lookupBroadcaster(req.getPathInfo());
        String message = req.getReader().readLine();
        if (message != null && message.indexOf("message") != -1) {
            b.broadcast((Object)message.substring("message=".length()));
        }
    }

    Broadcaster lookupBroadcaster(String pathInfo) {
        String[] decodedPath = pathInfo.split("/");
        Broadcaster b = BroadcasterFactory.getDefault().lookup((Object)decodedPath[decodedPath.length - 1], true);
        return b;
    }
}

