/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.multirequest.handlers;

import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.log4j.Logger;
import org.atmosphere.annotation.Broadcast;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.jersey.Broadcastable;
import org.atmosphere.jersey.SuspendResponse;

@Path(value="/subscribe/{topic}")
@Produces(value={"text/html;charset=ISO-8859-1"})
public class Subscriber {
    private static final Logger LOG = Logger.getLogger(Subscriber.class);
    @PathParam(value="topic")
    private Broadcaster topic;

    @GET
    public SuspendResponse<String> subscribe() {
        LOG.debug((Object)("OnSubscribe to topic " + this.topic));
        SuspendResponse sr = new SuspendResponse.SuspendResponseBuilder().broadcaster(this.topic).outputComments(true).build();
        return sr;
    }

    @POST
    @Broadcast
    public Broadcastable publish(@FormParam(value="message") String message) {
        LOG.debug((Object)("Receive message <" + message + ">, dispatch to other connected " + this.topic));
        return new Broadcastable((Object)message, (Object)"", this.topic);
    }
}

