/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.pubsub.websocket;

import java.rmi.RemoteException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.websocket.WebSocketEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.ScalaObject;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/pubsub/{topic}")
@Produces(value={"text/html;charset=ISO-8859-1"})
public class Console
implements WebSocketEventListener,
ScalaObject {
    private final Logger logger = LoggerFactory.getLogger(Console.class);

    public void onConnect(WebSocketEventListener.WebSocketEvent event) {
        this.logger().info("onConnect(): {}", (Object)event);
    }

    public void onDisconnect(WebSocketEventListener.WebSocketEvent event) {
        this.logger().info("onDisconnect(): {}", (Object)event);
    }

    public void onControl(WebSocketEventListener.WebSocketEvent event) {
        this.logger().info("onControl(): {}", (Object)event);
    }

    public void onClose(WebSocketEventListener.WebSocketEvent event) {
        this.logger().info("onClose(): {}", (Object)event);
    }

    public void onMessage(WebSocketEventListener.WebSocketEvent event) {
        this.logger().info("onMessage(): {}", (Object)event);
    }

    public void onHandshake(WebSocketEventListener.WebSocketEvent event) {
        this.logger().info("onHandshake(): {}", (Object)event);
    }

    public void onThrowable(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        this.logger().warn("onThrowable(): {}", event);
    }

    public void onBroadcast(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        this.logger().info("onBroadcast(): {}", event.getMessage());
    }

    public void onDisconnect(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        this.logger().info("onDisconnect(): {}:{}", (Object)((ServletRequest)event.getResource().getRequest()).getRemoteAddr(), (Object)BoxesRunTime.boxToInteger((int)((ServletRequest)event.getResource().getRequest()).getRemotePort()));
    }

    public void onResume(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        this.logger().info("onResume(): {}:{}", (Object)((ServletRequest)event.getResource().getRequest()).getRemoteAddr(), (Object)BoxesRunTime.boxToInteger((int)((ServletRequest)event.getResource().getRequest()).getRemotePort()));
    }

    public void onSuspend(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        this.logger().info("onSuspend(): {}:{}", (Object)((ServletRequest)event.getResource().getRequest()).getRemoteAddr(), (Object)BoxesRunTime.boxToInteger((int)((ServletRequest)event.getResource().getRequest()).getRemotePort()));
    }

    private final Logger logger() {
        return this.logger;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

