/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.pubsub.websocket;

import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.samples.pubsub.websocket.Console;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001\u001b\t\t\u0012\t^7pgBDWM]3IC:$G.\u001a:\u000b\u0005\r!\u0011!C<fEN|7m[3u\u0015\t)a!\u0001\u0004qk\n\u001cXO\u0019\u0006\u0003\u000f!\tqa]1na2,7O\u0003\u0002\n\u0015\u0005Q\u0011\r^7pgBDWM]3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\t\t\u0002\"A\u0004iC:$G.\u001a:\n\u0005M\u0001\"AI!cgR\u0014\u0018m\u0019;SK\u001adWm\u0019;pe\u0006#Xn\\:qQ\u0016\u0014X\rS1oI2,'\u000f\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003%ygNU3rk\u0016\u001cH\u000f\u0006\u0002#KA\u0011QcI\u0005\u0003IY\u0011A!\u00168ji\")ae\ba\u0001O\u0005\t!\u000f\u0005\u0002)W5\t\u0011F\u0003\u0002+\u0011\u0005\u00191\r\u001d:\n\u00051J#AE!u[>\u001c\b\u000f[3sKJ+7o\\;sG\u0016DQA\f\u0001\u0005\u0002=\nq\u0001Z3tiJ|\u0017\u0010F\u0001#\u0011\u0019\t\u0004\u0001\"\u0001\u0005e\u0005\tBn\\8lkB\u0014%o\\1eG\u0006\u001cH/\u001a:\u0015\u0005M2\u0004C\u0001\u00155\u0013\t)\u0014FA\u0006Ce>\fGmY1ti\u0016\u0014\b\"B\u001c1\u0001\u0004A\u0014\u0001\u00039bi\"LeNZ8\u0011\u0005ebdBA\u000b;\u0013\tYd#\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e\u0017\u0001")
public class AtmosphereHandler
extends AbstractReflectorAtmosphereHandler
implements ScalaObject {
    public void onRequest(AtmosphereResource r) {
        AtmosphereRequest req = r.getRequest();
        AtmosphereResponse res = r.getResponse();
        String method = req.getMethod();
        if ("GET".equalsIgnoreCase(method)) {
            r.addEventListener((AtmosphereResourceEventListener)new Console());
            res.setContentType("text/html;charset=ISO-8859-1");
            Broadcaster b = this.lookupBroadcaster(req.getPathInfo());
            r.setBroadcaster(b);
            if (req.getHeader("X-Atmosphere-Transport").equalsIgnoreCase("long-polling")) {
                req.setAttribute("org.atmosphere.resumeOnBroadcast", (Object)BoxesRunTime.boxToBoolean((boolean)true));
                r.suspend(-1L, false);
            } else {
                r.suspend(-1L);
            }
        } else if ("POST".equalsIgnoreCase(method)) {
            Broadcaster b = this.lookupBroadcaster(req.getPathInfo());
            String message = req.getReader().readLine();
            if (message != null && message.indexOf("message") != -1) {
                b.broadcast((Object)message.substring("message=".length()));
            }
        }
    }

    public void destroy() {
    }

    public Broadcaster lookupBroadcaster(String pathInfo) {
        String[] decodedPath = pathInfo.split("/");
        Broadcaster b = BroadcasterFactory.getDefault().lookup((Object)decodedPath[decodedPath.length - 1], true);
        return b;
    }
}

