/*
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://jersey.dev.java.net/CDDL+GPL.html
 * or jersey/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at jersey/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.atmosphere.samples.pubsub;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.atmosphere.annotation.Broadcast;
import org.atmosphere.annotation.Schedule;
import org.atmosphere.annotation.Suspend;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.jersey.Broadcastable;
import org.atmosphere.util.BroadcasterLookup;
import org.atmosphere.util.BroadcasterLookup.OutOfScopeException;

@Path("/")
public class PubSub {

    private final static String JUNK = "<!-- Comet is a programming technique that enables web " +
            "servers to send data to the client without having any need " +
            "for the client to request it. -->\n";

    @Suspend
    @GET
    @Path("/{topic}")
    @Produces("text/txt;charset=ISO-8859-1")
    public Broadcastable subscribe(@Context BroadcasterLookup bl,
                                   @Context Broadcaster br,
                                   @PathParam("topic") String topic) {

        StringBuilder b = new StringBuilder();
        // For IE, Safari and Chrome, we must output some junk to enable
        // streaming
        for (int i = 0; i < 10; i++) {
            b.append(JUNK);
        }

        Broadcaster broadcaster = null;
        try {
            broadcaster = bl.lookup(topic);
        } catch (OutOfScopeException ex) {
            Logger.getLogger(PubSub.class.getName()).log(Level.SEVERE, null, ex);
        }

        // Just use the one we just got
        if (broadcaster == null){
            broadcaster = br;
            broadcaster.setName(topic);
        }

        Broadcastable broadcastible = new Broadcastable(b.toString(),broadcaster);

        return broadcastible;
    }

    @GET
    @Path("/{topic}/{message}")
    @Produces("text/txt;charset=ISO-8859-1")
    @Broadcast
    public Broadcastable publish(@Context BroadcasterLookup bl,
                                 @PathParam("topic") String topic,
                                 @PathParam("message") String message){

        Broadcaster broadcaster = null;
        try {
            broadcaster = bl.lookup(topic);
        } catch (OutOfScopeException ex) {
            Logger.getLogger(PubSub.class.getName()).log(Level.SEVERE, null, ex);
        }
        Broadcastable broadcastible = new Broadcastable(message,broadcaster);

        return broadcastible;
    }

    @Schedule(period=30)
    @GET
    @Path("/ping")
    public String pingSuspendedClients(){
        return "Atmosphere__ping";
    }
}
