/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.pubsub;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.atmosphere.annotation.Broadcast;
import org.atmosphere.annotation.Schedule;
import org.atmosphere.annotation.Suspend;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.jersey.Broadcastable;
import org.atmosphere.util.BroadcasterLookup;

@Path(value="/")
public class PubSub {
    private static final String JUNK = "<!-- Comet is a programming technique that enables web servers to send data to the client without having any need for the client to request it. -->\n";

    @Suspend
    @GET
    @Path(value="/{topic}")
    @Produces(value={"text/txt;charset=ISO-8859-1"})
    public Broadcastable subscribe(@Context BroadcasterLookup bl, @Context Broadcaster br, @PathParam(value="topic") String topic) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            b.append(JUNK);
        }
        Broadcaster broadcaster = null;
        try {
            broadcaster = bl.lookup(topic);
        }
        catch (BroadcasterLookup.OutOfScopeException ex) {
            Logger.getLogger(PubSub.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (broadcaster == null) {
            broadcaster = br;
            broadcaster.setName(topic);
        }
        Broadcastable broadcastible = new Broadcastable((Object)b.toString(), broadcaster);
        return broadcastible;
    }

    @GET
    @Path(value="/{topic}/{message}")
    @Produces(value={"text/txt;charset=ISO-8859-1"})
    @Broadcast
    public Broadcastable publish(@Context BroadcasterLookup bl, @PathParam(value="topic") String topic, @PathParam(value="message") String message) {
        Broadcaster broadcaster = null;
        try {
            broadcaster = bl.lookup(topic);
        }
        catch (BroadcasterLookup.OutOfScopeException ex) {
            Logger.getLogger(PubSub.class.getName()).log(Level.SEVERE, null, ex);
        }
        Broadcastable broadcastible = new Broadcastable((Object)message, broadcaster);
        return broadcastible;
    }

    @Schedule(period=30)
    @GET
    @Path(value="/ping")
    public String pingSuspendedClients() {
        return "Atmosphere__ping";
    }
}

