/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.pubsub;

import java.util.concurrent.TimeUnit;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.atmosphere.annotation.Broadcast;
import org.atmosphere.annotation.Cluster;
import org.atmosphere.annotation.Schedule;
import org.atmosphere.annotation.Suspend;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.jersey.Broadcastable;
import org.atmosphere.plugin.cluster.jgroups.JGroupsFilter;
import org.atmosphere.samples.pubsub.EventsLogger;
import org.atmosphere.samples.pubsub.JAXBBean;

@Path(value="/{topic}")
@Produces(value={"text/plain;charset=ISO-8859-1"})
public class PubSub {
    @PathParam(value="topic")
    private Broadcaster topic;

    @GET
    @Suspend(listeners={EventsLogger.class})
    public Broadcastable subscribe() {
        return this.broadcast("OK");
    }

    @GET
    @Suspend(resumeOnBroadcast=true)
    @Path(value="subscribeAndResume")
    public Broadcastable subscribeAndResume() {
        return this.broadcast("OK");
    }

    @POST
    @Produces(value={"application/xml"})
    @Broadcast
    public Broadcastable publishWithXML(@FormParam(value="message") String message) {
        return new Broadcastable((Object)new JAXBBean(message), this.topic);
    }

    @POST
    @Broadcast
    @Cluster(name="chat", value={JGroupsFilter.class})
    public Broadcastable publish(@FormParam(value="message") String message) {
        return this.broadcast(message);
    }

    @Schedule(period=5, resumeOnBroadcast=true)
    @POST
    @Path(value="scheduleAndResume")
    public Broadcastable scheduleAndResume(@FormParam(value="message") String message) {
        return this.broadcast(message);
    }

    @Schedule(period=10, waitFor=5)
    @POST
    @Path(value="delaySchedule")
    public Broadcastable delaySchedule(@FormParam(value="message") String message) {
        return this.broadcast(message);
    }

    @Schedule(period=5)
    @POST
    @Path(value="schedule")
    public Broadcastable schedule(@FormParam(value="message") String message) {
        return this.broadcast(message);
    }

    @Broadcast(delay=5)
    @POST
    @Path(value="delay")
    public Broadcastable delayPublish(@FormParam(value="message") String message) {
        return this.broadcast(message);
    }

    @Broadcast(delay=5, resumeOnBroadcast=true)
    @POST
    @Path(value="delayAndResume")
    public Broadcastable delayPublishAndResume(@FormParam(value="message") String message) {
        return this.broadcast(message);
    }

    @Path(value="buffer")
    @POST
    @Broadcast(delay=0)
    public Broadcastable buffer(@FormParam(value="message") String message) {
        return this.broadcast(message);
    }

    @POST
    @Path(value="broadcast")
    public String manualDelayBroadcast(@FormParam(value="message") String message) {
        this.topic.delayBroadcast((Object)message, 10L, TimeUnit.SECONDS);
        return message;
    }

    Broadcastable broadcast(String m) {
        return new Broadcastable((Object)(m + "\n"), this.topic);
    }
}

